/*
 * Copyright (c) 2019 Telekom Deutschland AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.telekom.smartcredentials.core.plugins.callbacks;

import android.os.Parcel;
import android.os.Parcelable;

public abstract class BasePluginCallback implements Parcelable {

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(describeContents());
    }

    public static final Creator CREATOR = new Creator() {
        public BasePluginCallback createFromParcel(Parcel in) {
            return null;
        }

        public BasePluginCallback[] newArray(int size) {
            return new BasePluginCallback[size];
        }
    };
}
