/*
 * Copyright (c) 2019 Telekom Deutschland AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.telekom.smartcredentials.core.di;

import android.content.Context;
import androidx.annotation.NonNull;

import java.util.Set;

import de.telekom.smartcredentials.core.controllers.CoreController;
import de.telekom.smartcredentials.core.rootdetector.RootDetectionApi;
import de.telekom.smartcredentials.core.rootdetector.RootDetectionController;
import de.telekom.smartcredentials.core.rootdetector.RootDetectionOption;

/**
 * Created by Lucian Iacob on November 12, 2018.
 */
public class ObjectGraphCreator {

    private static ObjectGraphCreator sInstance;

    private final Context mContext;
    private final boolean mRootCheckerEnabled;
    private final Set<RootDetectionOption> mRootDetectionOptions;

    private ObjectGraphCreator(Context context, boolean rootCheckerEnabled,
                               Set<RootDetectionOption> rootDetectionOptions) {
        mContext = context;
        mRootCheckerEnabled = rootCheckerEnabled;
        mRootDetectionOptions = rootDetectionOptions;
    }

    public static ObjectGraphCreator getInstance(Context context, boolean rootCheckerEnabled,
                                                 Set<RootDetectionOption> rootDetectionOptions) {
        if (sInstance == null) {
            sInstance = new ObjectGraphCreator(context, rootCheckerEnabled, rootDetectionOptions);
        }
        return sInstance;
    }

    public static void destroy() {
        sInstance = null;
    }

    @NonNull
    public CoreController provideCoreController(Context context) {
        return new CoreController(mContext, provideRootDetectionApi(context),
                mRootCheckerEnabled, mRootDetectionOptions);
    }

    @Provides
    @NonNull
    private RootDetectionApi provideRootDetectionApi(Context context) {
        return new RootDetectionController(context);
    }

    public Context getContext() {
        return mContext;
    }
}
