/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.jsonfilter.operator.comparison;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.path.PathCompiler;
import de.telekom.jsonfilter.exception.NoSingleValueException;
import de.telekom.jsonfilter.operator.EvaluationResult;
import de.telekom.jsonfilter.operator.Operator;
import de.telekom.jsonfilter.operator.ValidationResult;
import de.telekom.jsonfilter.operator.comparison.ComparisonOperatorEnum;
import de.telekom.jsonfilter.operator.comparison.ContainsOperator;
import de.telekom.jsonfilter.operator.comparison.EqualsOperator;
import de.telekom.jsonfilter.operator.comparison.GreaterEqualOperator;
import de.telekom.jsonfilter.operator.comparison.GreaterThanOperator;
import de.telekom.jsonfilter.operator.comparison.InOperator;
import de.telekom.jsonfilter.operator.comparison.LessEqualOperator;
import de.telekom.jsonfilter.operator.comparison.LessThanOperator;
import de.telekom.jsonfilter.operator.comparison.NotContainsOperator;
import de.telekom.jsonfilter.operator.comparison.NotEqualsOperator;
import de.telekom.jsonfilter.operator.comparison.RegexOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minidev.json.JSONArray;

public abstract class ComparisonOperator<T>
implements Operator {
    final ComparisonOperatorEnum operator;
    T expectedValue;
    String jsonPath;

    protected ComparisonOperator(ComparisonOperatorEnum operator) {
        this.operator = operator;
    }

    public static <T> Operator instantiate(ComparisonOperatorEnum operator, String jsonPath, T expectedValue) {
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case ComparisonOperatorEnum.EQ -> new EqualsOperator<T>(jsonPath, expectedValue);
            case ComparisonOperatorEnum.NE -> new NotEqualsOperator<T>(jsonPath, expectedValue);
            case ComparisonOperatorEnum.RX -> new RegexOperator<T>(jsonPath, expectedValue);
            case ComparisonOperatorEnum.LT -> new LessThanOperator<T>(jsonPath, expectedValue);
            case ComparisonOperatorEnum.LE -> new LessEqualOperator<T>(jsonPath, expectedValue);
            case ComparisonOperatorEnum.GT -> new GreaterThanOperator<T>(jsonPath, expectedValue);
            case ComparisonOperatorEnum.GE -> new GreaterEqualOperator<T>(jsonPath, expectedValue);
            case ComparisonOperatorEnum.IN -> new InOperator(jsonPath, (List)expectedValue);
            case ComparisonOperatorEnum.CT -> new ContainsOperator<T>(jsonPath, expectedValue);
            case ComparisonOperatorEnum.NCT -> new NotContainsOperator<T>(jsonPath, expectedValue);
        };
    }

    @Override
    public EvaluationResult evaluate(String json) {
        return this.compare(json, this.jsonPath, this.expectedValue);
    }

    abstract EvaluationResult compare(String var1, String var2, T var3);

    protected Comparable<T> getActualValue(String json, String jsonPath) throws NoSingleValueException {
        List<Comparable<T>> valueList = this.getActualValues(json, jsonPath);
        if (valueList.size() == 1) {
            return valueList.getFirst();
        }
        throw new NoSingleValueException(jsonPath, valueList.size());
    }

    protected List<Comparable<T>> getActualValues(String json, String jsonPath) {
        List<Comparable<T>> valueList = new ArrayList<Comparable<T>>();
        Object readResult = JsonPath.read((String)json, (String)jsonPath, (Predicate[])new Predicate[0]);
        if (readResult instanceof Comparable) {
            valueList.add((Comparable)readResult);
        } else if (readResult instanceof JSONArray) {
            JSONArray rrArray = (JSONArray)readResult;
            valueList = rrArray.stream().flatMap(v -> {
                if (v instanceof JSONArray) {
                    JSONArray ja = (JSONArray)v;
                    return ja.stream();
                }
                return Stream.of(v);
            }).filter(Comparable.class::isInstance).map(rr -> (Comparable)rr).collect(Collectors.toList());
        }
        return valueList;
    }

    @Override
    public ValidationResult validate() {
        try {
            PathCompiler.compile((String)this.jsonPath, (Predicate[])new Predicate[0]);
            return ValidationResult.valid();
        }
        catch (InvalidPathException ipe) {
            return ValidationResult.withError(ipe.getLocalizedMessage(), this.getOperator());
        }
    }

    public T getExpectedValue() {
        return this.expectedValue;
    }

    public String getJsonPath() {
        return this.jsonPath;
    }

    @Override
    public ComparisonOperatorEnum getOperator() {
        return this.operator;
    }
}

