/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.jsonfilter.operator;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.telekom.jsonfilter.operator.Operator;
import de.telekom.jsonfilter.operator.logic.LogicOperator;
import de.telekom.jsonfilter.serde.OperatorDeserializer;
import de.telekom.jsonfilter.serde.OperatorSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(value={"om"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class EvaluationResult {
    String operatorName;
    boolean match;
    String causeDescription;
    Operator operator;
    List<EvaluationResult> childOperators;
    static ObjectMapper om = EvaluationResult.initOm();

    private static ObjectMapper initOm() {
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory());
        SimpleModule m = new SimpleModule();
        m.addDeserializer(Operator.class, (JsonDeserializer)new OperatorDeserializer());
        m.addSerializer(Operator.class, (JsonSerializer)new OperatorSerializer());
        om.registerModule((Module)m);
        return om;
    }

    private EvaluationResult(boolean match, String operatorName, Operator operator, String causeDescription, List<EvaluationResult> childOperators) {
        this.match = match;
        this.operatorName = operatorName;
        this.operator = operator;
        this.causeDescription = causeDescription;
        this.childOperators = childOperators;
    }

    public static EvaluationResult empty() {
        return new EvaluationResult(true, "noop", null, null, null);
    }

    public static EvaluationResult valid(Operator op) {
        return new EvaluationResult(true, op.getOperator().getValue(), op, "", Collections.emptyList());
    }

    public static EvaluationResult valid(Operator op, List<EvaluationResult> evaluationResults) {
        return new EvaluationResult(true, op.getOperator().getValue(), op, "", evaluationResults);
    }

    public static EvaluationResult withError(Operator op, String causeDescription) {
        return new EvaluationResult(false, op.getOperator().getValue(), op, causeDescription, new ArrayList<EvaluationResult>());
    }

    public static EvaluationResult fromResultList(LogicOperator logicOperator, List<EvaluationResult> evaluationResults) {
        switch (logicOperator.getOperator()) {
            case AND: {
                if (evaluationResults.stream().allMatch(EvaluationResult::isMatch)) {
                    return EvaluationResult.valid(logicOperator, Collections.emptyList());
                }
                return new EvaluationResult(false, logicOperator.getOperator().getValue(), null, "Not all child-operators matched.", evaluationResults);
            }
            case OR: {
                if (evaluationResults.stream().anyMatch(EvaluationResult::isMatch)) {
                    return EvaluationResult.valid(logicOperator, Collections.emptyList());
                }
                return new EvaluationResult(false, logicOperator.getOperator().getValue(), null, "No child-operator matched.", evaluationResults);
            }
        }
        return null;
    }

    public String toString() {
        try {
            return om.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "invalid EvaluationResult";
        }
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public boolean isMatch() {
        return this.match;
    }

    public String getCauseDescription() {
        return this.causeDescription;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<EvaluationResult> getChildOperators() {
        return this.childOperators;
    }
}

