/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.jsonfilter.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.telekom.jsonfilter.exception.OperatorParsingException;
import de.telekom.jsonfilter.operator.Operator;
import de.telekom.jsonfilter.operator.ValidationResult;
import de.telekom.jsonfilter.operator.comparison.ComparisonOperator;
import de.telekom.jsonfilter.operator.comparison.ComparisonOperatorEnum;
import de.telekom.jsonfilter.operator.logic.LogicOperator;
import de.telekom.jsonfilter.operator.logic.LogicOperatorEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorDeserializer
extends StdDeserializer<Operator> {
    private static final Logger log = LoggerFactory.getLogger(OperatorDeserializer.class);
    private final int maxComplexity;
    private static final int DEFAULT_MAX_COMPLEXITY = 42;

    public OperatorDeserializer() {
        this(null);
    }

    public OperatorDeserializer(int maxComplexity) {
        super((Class)null);
        this.maxComplexity = maxComplexity;
    }

    public OperatorDeserializer(Class<?> vc) {
        super(vc);
        this.maxComplexity = 42;
    }

    public OperatorDeserializer(Class<?> vc, int maxComplexity) {
        super(vc);
        this.maxComplexity = maxComplexity;
    }

    public Operator deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode n = (JsonNode)p.getCodec().readTree(p);
        Pair<Operator, Integer> opPair = this.parseOperator(n, 0);
        if ((Integer)opPair.getRight() > this.maxComplexity) {
            throw new OperatorParsingException("Complexity of the filter exceeds the allowed complexity of " + this.maxComplexity, n);
        }
        return (Operator)opPair.getLeft();
    }

    private Pair<Operator, Integer> parseOperator(JsonNode n, int currentComplexity) throws OperatorParsingException {
        if (currentComplexity > this.maxComplexity) {
            throw new OperatorParsingException("Complexity of the filter exceeds the allowed complexity of " + this.maxComplexity, n);
        }
        if (n.fieldNames().hasNext()) {
            JsonNode opNode;
            String opName = ((String)n.fieldNames().next()).toUpperCase();
            Operator op = this.getComparisonOperator(n, opName, opNode = n.get((String)n.fieldNames().next()));
            if (op != null) {
                return Pair.of((Object)op, (Object)(++currentComplexity));
            }
            Pair<Operator, Integer> opPair = this.getLogicOperator(opName, opNode, currentComplexity);
            if (opPair != null && opPair.getLeft() != null) {
                return Pair.of((Object)((Operator)opPair.getLeft()), (Object)((Integer)opPair.getRight() + 1));
            }
            throw new OperatorParsingException("Operator " + opName + " is no valid operator", n);
        }
        throw new OperatorParsingException("Could not find field name", n);
    }

    private Pair<Operator, Integer> getLogicOperator(String opName, JsonNode opNode, int currentComplexity) throws OperatorParsingException {
        try {
            LogicOperatorEnum opAbbr = LogicOperatorEnum.valueOf(opName);
            ArrayList<Operator> opList = new ArrayList<Operator>();
            for (JsonNode child : opNode) {
                Pair<Operator, Integer> opPair = this.parseOperator(child, currentComplexity);
                opList.add((Operator)opPair.getLeft());
                currentComplexity = (Integer)opPair.getRight();
            }
            return Pair.of((Object)LogicOperator.instantiate(opAbbr, opList), (Object)currentComplexity);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private Operator getComparisonOperator(JsonNode n, String opName, JsonNode opNode) throws OperatorParsingException {
        try {
            ComparisonOperatorEnum opAbbr = ComparisonOperatorEnum.valueOf(opName);
            if (!opNode.has("field")) {
                throw new OperatorParsingException("Mandatory field \"field\" not set", n);
            }
            if (!opNode.has("value")) {
                throw new OperatorParsingException("Mandatory field \"value\" not set", n);
            }
            JsonNode valueNode = opNode.get("value");
            Object value = this.getValueFromNode(valueNode);
            Operator op = ComparisonOperator.instantiate(opAbbr, opNode.get("field").textValue(), value);
            assert (op != null);
            ValidationResult vResult = op.validate();
            if (vResult.isValid()) {
                return op;
            }
            throw new OperatorParsingException("Operator of type " + vResult.getOperator().getValue() + " was created, but is not valid: " + vResult.getValidationError(), opNode);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private Object getValueFromNode(JsonNode valueNode) throws OperatorParsingException {
        switch (valueNode.getNodeType()) {
            case STRING: {
                return valueNode.textValue();
            }
            case NUMBER: {
                return valueNode.numberValue();
            }
            case BOOLEAN: {
                return valueNode.booleanValue();
            }
            case ARRAY: {
                List<Optional> optionals = StreamSupport.stream(valueNode.spliterator(), false).map(this::uncheckedGetValueFromNode).toList();
                if (optionals.contains(Optional.empty())) {
                    throw new OperatorParsingException("Invalid type in array", valueNode);
                }
                return optionals.stream().filter(Optional::isPresent).map(Optional::get).toList();
            }
        }
        throw new OperatorParsingException("Cannot use value of type " + String.valueOf(valueNode.getNodeType()), valueNode);
    }

    private Optional<Object> uncheckedGetValueFromNode(JsonNode valueNode) {
        try {
            return Optional.of(this.getValueFromNode(valueNode));
        }
        catch (OperatorParsingException ex) {
            return Optional.empty();
        }
    }
}

