/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.jsonfilter.operator.logic;

import de.telekom.jsonfilter.operator.Operator;
import de.telekom.jsonfilter.operator.ValidationResult;
import de.telekom.jsonfilter.operator.logic.AndOperator;
import de.telekom.jsonfilter.operator.logic.LogicOperatorEnum;
import de.telekom.jsonfilter.operator.logic.OrOperator;
import java.util.ArrayList;
import java.util.List;

public abstract class LogicOperator
implements Operator {
    final LogicOperatorEnum operator;
    List<Operator> operators = new ArrayList<Operator>();

    protected LogicOperator(LogicOperatorEnum operator) {
        this.operator = operator;
    }

    @Override
    public ValidationResult validate() {
        if (this.operators.stream().map(Operator::validate).allMatch(ValidationResult::isValid)) {
            return ValidationResult.valid();
        }
        return ValidationResult.withError("One or more children are not valid", this.getOperator());
    }

    public static Operator instantiate(LogicOperatorEnum operator, List<Operator> operatorList) {
        return switch (operator) {
            case LogicOperatorEnum.AND -> new AndOperator(operatorList);
            case LogicOperatorEnum.OR -> new OrOperator(operatorList);
            default -> null;
        };
    }

    @Override
    public LogicOperatorEnum getOperator() {
        return this.operator;
    }

    public List<Operator> getOperators() {
        return this.operators;
    }
}

