/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.random.e1;

import de.team33.patterns.random.e1.BitFactory;
import de.team33.patterns.random.e1.RandomUtil;
import java.math.BigInteger;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;

@FunctionalInterface
public interface XRandom
extends BitFactory {
    public static XRandom using(BitFactory backing) {
        return backing::anyBits;
    }

    public static XRandom using(Random random) {
        return XRandom.using(BitFactory.using(random));
    }

    default public boolean anyBoolean() {
        return this.anyBits(1).equals(BigInteger.ONE);
    }

    default public byte anyByte() {
        return this.anyBits(8).byteValue();
    }

    default public short anyShort() {
        return this.anyBits(16).shortValue();
    }

    default public int anyInt() {
        return this.anyBits(32).intValue();
    }

    default public int anyInt(int bound) {
        return this.anyBigInteger(BigInteger.valueOf(bound)).intValue();
    }

    default public int anyInt(int min, int bound) {
        return this.anyBigInteger(BigInteger.valueOf(min), BigInteger.valueOf(bound)).intValue();
    }

    default public long anyLong() {
        return this.anyBits(64).longValue();
    }

    default public float anyFloat() {
        float numerator = this.anyBits(32).floatValue();
        float denominator = BigInteger.ONE.shiftLeft(32).floatValue();
        return numerator / denominator;
    }

    default public double anyDouble() {
        double numerator = this.anyBits(64).doubleValue();
        double denominator = BigInteger.ONE.shiftLeft(64).doubleValue();
        return numerator / denominator;
    }

    default public char anyChar() {
        char result = RandomUtil.anyRawChar(this);
        while (!Character.isDefined(result)) {
            result = RandomUtil.anyRawChar(this);
        }
        return result;
    }

    default public char anyChar(String characters) {
        return characters.charAt(this.anyInt(characters.length()));
    }

    default public BigInteger anyBigInteger(BigInteger bound) {
        if (BigInteger.ZERO.compareTo(bound) < 0) {
            int numBits = bound.bitLength() + 64;
            BigInteger numerator = bound.multiply(this.anyBits(numBits));
            BigInteger denominator = BigInteger.ONE.shiftLeft(numBits);
            return numerator.divide(denominator);
        }
        throw new IllegalArgumentException("<bound> must be greater than ZERO but was " + bound);
    }

    default public BigInteger anyBigInteger(BigInteger min, BigInteger bound) {
        return this.anyBigInteger(bound.subtract(min)).add(min);
    }

    default public String anyString(int length) {
        return this.anyString(length, this::anyChar);
    }

    default public String anyString(int length, String characters) {
        return this.anyString(length, () -> Character.valueOf(this.anyChar(characters)));
    }

    default public String anyString(int length, Supplier<Character> supplier) {
        if (0 <= length) {
            return Stream.generate(supplier).limit(length).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        }
        throw new IllegalArgumentException("<length> must be greater than or equal to zero but was " + length);
    }

    default public <T> T anyOf(T ... values) {
        return values[this.anyInt(values.length)];
    }
}

