/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.random.e1;

import de.team33.patterns.production.e1.FactoryHub;
import de.team33.patterns.random.e1.BitFactory;
import de.team33.patterns.random.e1.XRandom;
import java.math.BigInteger;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class RandomHub
implements XRandom {
    public static final Byte BYTE = 127;
    public static final Short SHORT = Short.MAX_VALUE;
    public static final Integer INTEGER = Integer.MAX_VALUE;
    public static final Long LONG = Long.MAX_VALUE;
    public static final Float FLOAT = Float.valueOf(Float.MAX_VALUE);
    public static final Double DOUBLE = Double.MAX_VALUE;
    public static final Character CHARACTER = Character.valueOf('\u00f8');
    public static final String STRING = "\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8\u00f8";
    private final BitFactory bitFactory;
    private final FactoryHub<RandomHub> backing;
    private final String stdCharacters;

    private RandomHub(Builder builder) {
        this.backing = FactoryHub.instance((FactoryHub.Collector)builder, () -> this);
        this.bitFactory = (BitFactory)builder.newBitFactory.get();
        this.stdCharacters = builder.stdCharacters;
    }

    public static Builder builder() {
        return (Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)new Builder().on(false).apply(XRandom::anyBoolean))).on(true).apply(XRandom::anyBoolean))).on(BYTE).apply(XRandom::anyByte))).on(SHORT).apply(XRandom::anyShort))).on(INTEGER).apply(XRandom::anyInt))).on(LONG).apply(XRandom::anyLong))).on(FLOAT).apply(XRandom::anyFloat))).on(DOUBLE).apply(XRandom::anyDouble))).on(CHARACTER).apply(rnd -> Character.valueOf(rnd.anyChar(rnd.stdCharacters))))).on(STRING).apply(rnd -> rnd.anyString(rnd.anyInt(1 + rnd.anyInt(STRING.length())), rnd.stdCharacters)));
    }

    public final <R> R any(R token) {
        return (R)this.backing.get(token);
    }

    public final <R> Stream<R> stream(R token) {
        return this.backing.stream(token);
    }

    public final <R> Stream<R> stream(R token, int length) {
        return this.backing.stream(token, length);
    }

    public final <K, V> Map<K, V> map(K keyToken, V valueToken, int size) {
        return this.backing.map(keyToken, valueToken, size);
    }

    public final <K, V> Map<K, V> map(Map<K, V> template) {
        return this.backing.map(template);
    }

    public final <T, R> R map(T template, Function<T, Map<?, ?>> toMap, Function<Map<?, ?>, R> reMap) {
        return (R)this.backing.map(template, toMap, reMap);
    }

    @Override
    public final BigInteger anyBits(int numBits) {
        return this.bitFactory.anyBits(numBits);
    }

    public static class Builder
    extends FactoryHub.Collector<RandomHub, Builder> {
        private static final String STD_CHARACTERS = "abcdefghijklmnopqrstuvwxyz-ABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789 @\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df!\u00a7$%&";
        private String stdCharacters = "abcdefghijklmnopqrstuvwxyz-ABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789 @\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df!\u00a7$%&";
        private Supplier<BitFactory> newBitFactory = () -> BitFactory.using(new Random());

        private Builder() {
        }

        protected final Builder getBuilder() {
            return this;
        }

        public final Builder setStdCharacters(String characters) {
            this.stdCharacters = characters;
            return this;
        }

        public final Builder setNewBitFactory(Supplier<BitFactory> newBitFactory) {
            this.newBitFactory = newBitFactory;
            return this;
        }

        public final Builder setNewRandom(Supplier<? extends Random> newRandom) {
            return this.setNewBitFactory(() -> BitFactory.using((Random)newRandom.get()));
        }

        public final RandomHub build() {
            return new RandomHub(this);
        }
    }
}

