/*
 * Decompiled with CFR 0.152.
 */
package de.teamholycow.acc.resultserver.processor.driver;

import de.teamholycow.acc.resultserver.model.json.JsonResult;
import de.teamholycow.acc.resultserver.model.statistic.Driver;
import de.teamholycow.acc.resultserver.model.statistic.DriverPitStop;
import de.teamholycow.acc.resultserver.model.statistic.DriverStatistic;
import de.teamholycow.acc.resultserver.model.statistic.Lap;
import de.teamholycow.acc.resultserver.model.statistic.StatisticResult;
import de.teamholycow.acc.resultserver.processor.driver.DriverProcessor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PitStopDriverProcessor
implements DriverProcessor {
    private static final Logger log = LoggerFactory.getLogger(PitStopDriverProcessor.class);
    public static final int PIT_STOP_IDENTIFIER = 2000;

    @Override
    public void process(StatisticResult statisticResult, Driver driver, JsonResult jsonResult) {
        DriverStatistic driverStatistic = driver.getDriverStatistic();
        driverStatistic.setPitStops(this.getPitTime(driver.getLaps(), driverStatistic.getConsistencyPercentage()));
    }

    public List<DriverPitStop> getPitTime(List<Lap> laps, double consistencyFactor) {
        ArrayList<DriverPitStop> driverPitStopList = new ArrayList<DriverPitStop>();
        long sectorOneBest = laps.stream().mapToLong(l -> l.getLapTime().getSectorOne()).min().orElse(0L);
        long sectorTwoBest = laps.stream().mapToLong(l -> l.getLapTime().getSectorTwo()).min().orElse(0L);
        long sectorThreeBest = laps.stream().mapToLong(l -> l.getLapTime().getSectorThree()).min().orElse(0L);
        double sectorOneAvg = laps.stream().mapToLong(l -> l.getLapTime().getSectorOne()).filter(t -> t < sectorOneBest + 2000L).average().orElse(0.0);
        double sectorTwoAvg = laps.stream().mapToLong(l -> l.getLapTime().getSectorTwo()).filter(t -> t < sectorTwoBest + 2000L).average().orElse(0.0);
        double sectorThreeAvg = laps.stream().mapToLong(l -> l.getLapTime().getSectorThree()).filter(t -> t < sectorThreeBest + 2000L).average().orElse(0.0);
        for (int i = 0; i < laps.size(); ++i) {
            double pitTime;
            if (i + 1 >= laps.size()) continue;
            long lastSector = laps.get(i).getLapTime().getSectorThree();
            long firstSectorNextRound = laps.get(i + 1).getLapTime().getSectorOne();
            if (lastSector < sectorThreeBest + 2000L || firstSectorNextRound < sectorOneBest + 2000L || (pitTime = (double)lastSector - sectorThreeAvg + ((double)firstSectorNextRound - sectorOneAvg)) < 10000.0) continue;
            log.info("found pitstop in round {} with a time of {}s", (Object)i, (Object)pitTime);
            driverPitStopList.add(DriverPitStop.builder().round(i).stopTime(Double.valueOf(pitTime).longValue()).build());
        }
        return driverPitStopList;
    }
}

