/*
 * Decompiled with CFR 0.152.
 */
package de.teamholycow.acc.resultserver.processor.driver;

import de.teamholycow.acc.resultserver.model.json.JsonResult;
import de.teamholycow.acc.resultserver.model.statistic.Driver;
import de.teamholycow.acc.resultserver.model.statistic.DriverStatistic;
import de.teamholycow.acc.resultserver.model.statistic.Lap;
import de.teamholycow.acc.resultserver.model.statistic.StatisticResult;
import de.teamholycow.acc.resultserver.processor.driver.DriverProcessor;
import java.util.List;
import java.util.OptionalDouble;

public class ConsistencyDriverProcessor
implements DriverProcessor {
    private static final int CONSISTENCY_LAP_OFFSET = 21000;
    private static final boolean IGNORE_FIRST_ROUND = true;
    private static final boolean INCLUDE_ONLY_VALID_ROUNDS = false;

    @Override
    public void process(StatisticResult statisticResult, Driver driver, JsonResult jsonResult) {
        DriverStatistic driverStatistic = driver.getDriverStatistic();
        OptionalDouble consistency = this.getConsistency(driver.getLaps(), driverStatistic.getBestTime());
        driverStatistic.setConsistency(consistency.orElse(0.0));
        driverStatistic.setConsistencyPercentage(this.getConsistencyPercentage(driverStatistic.getBestTime(), consistency));
    }

    private double getConsistencyPercentage(long bestLap, OptionalDouble consistency) {
        if (consistency.isEmpty()) {
            return 0.0;
        }
        return 100.0 * ((double)bestLap / consistency.getAsDouble());
    }

    public OptionalDouble getConsistency(List<Lap> laps, long bestLap) {
        if (laps.size() <= 1) {
            return OptionalDouble.empty();
        }
        return laps.stream().filter(l -> this.isValidConsistencyLap((Lap)l, bestLap, ((Lap)laps.get(0)).getLapTime().getTime())).mapToLong(l -> l.getLapTime().getTime()).average();
    }

    private boolean isValidConsistencyLap(Lap lap, long bestLap, long firstLap) {
        if (lap.getLapTime().getTime() == bestLap) {
            return false;
        }
        if (firstLap == lap.getLapTime().getTime()) {
            return false;
        }
        return lap.getLapTime().getTime() <= bestLap + 21000L;
    }
}

