/*
 * Decompiled with CFR 0.152.
 */
package de.teamholycow.acc.resultserver.model.statistic;

import de.teamholycow.acc.data.SessionType;
import de.teamholycow.acc.data.Track;
import de.teamholycow.acc.resultserver.model.statistic.Driver;
import de.teamholycow.acc.resultserver.model.statistic.LapTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;

public class StatisticResult {
    private SessionType sessionType;
    private Track track;
    private String serverName;
    private LapTime bestLap;
    private boolean wetSession;
    private OptionalLong minStopTime = OptionalLong.empty();
    private List<Driver> drivers = new ArrayList<Driver>();
    private Map<Long, Driver> carDriverLookup = new HashMap<Long, Driver>();

    public final Driver getDriver(long carId) {
        return this.carDriverLookup.get(carId);
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public Track getTrack() {
        return this.track;
    }

    public String getServerName() {
        return this.serverName;
    }

    public LapTime getBestLap() {
        return this.bestLap;
    }

    public boolean isWetSession() {
        return this.wetSession;
    }

    public OptionalLong getMinStopTime() {
        return this.minStopTime;
    }

    public List<Driver> getDrivers() {
        return this.drivers;
    }

    public Map<Long, Driver> getCarDriverLookup() {
        return this.carDriverLookup;
    }

    public void setSessionType(SessionType sessionType) {
        this.sessionType = sessionType;
    }

    public void setTrack(Track track) {
        this.track = track;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setBestLap(LapTime bestLap) {
        this.bestLap = bestLap;
    }

    public void setWetSession(boolean wetSession) {
        this.wetSession = wetSession;
    }

    public void setMinStopTime(OptionalLong minStopTime) {
        this.minStopTime = minStopTime;
    }

    public void setDrivers(List<Driver> drivers) {
        this.drivers = drivers;
    }

    public void setCarDriverLookup(Map<Long, Driver> carDriverLookup) {
        this.carDriverLookup = carDriverLookup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticResult)) {
            return false;
        }
        StatisticResult other = (StatisticResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isWetSession() != other.isWetSession()) {
            return false;
        }
        SessionType this$sessionType = this.getSessionType();
        SessionType other$sessionType = other.getSessionType();
        if (this$sessionType == null ? other$sessionType != null : !this$sessionType.equals(other$sessionType)) {
            return false;
        }
        Track this$track = this.getTrack();
        Track other$track = other.getTrack();
        if (this$track == null ? other$track != null : !this$track.equals(other$track)) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
            return false;
        }
        LapTime this$bestLap = this.getBestLap();
        LapTime other$bestLap = other.getBestLap();
        if (this$bestLap == null ? other$bestLap != null : !this$bestLap.equals(other$bestLap)) {
            return false;
        }
        OptionalLong this$minStopTime = this.getMinStopTime();
        OptionalLong other$minStopTime = other.getMinStopTime();
        if (this$minStopTime == null ? other$minStopTime != null : !((Object)this$minStopTime).equals(other$minStopTime)) {
            return false;
        }
        List<Driver> this$drivers = this.getDrivers();
        List<Driver> other$drivers = other.getDrivers();
        if (this$drivers == null ? other$drivers != null : !((Object)this$drivers).equals(other$drivers)) {
            return false;
        }
        Map<Long, Driver> this$carDriverLookup = this.getCarDriverLookup();
        Map<Long, Driver> other$carDriverLookup = other.getCarDriverLookup();
        return !(this$carDriverLookup == null ? other$carDriverLookup != null : !((Object)this$carDriverLookup).equals(other$carDriverLookup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatisticResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWetSession() ? 79 : 97);
        SessionType $sessionType = this.getSessionType();
        result = result * 59 + ($sessionType == null ? 43 : $sessionType.hashCode());
        Track $track = this.getTrack();
        result = result * 59 + ($track == null ? 43 : $track.hashCode());
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        LapTime $bestLap = this.getBestLap();
        result = result * 59 + ($bestLap == null ? 43 : $bestLap.hashCode());
        OptionalLong $minStopTime = this.getMinStopTime();
        result = result * 59 + ($minStopTime == null ? 43 : ((Object)$minStopTime).hashCode());
        List<Driver> $drivers = this.getDrivers();
        result = result * 59 + ($drivers == null ? 43 : ((Object)$drivers).hashCode());
        Map<Long, Driver> $carDriverLookup = this.getCarDriverLookup();
        result = result * 59 + ($carDriverLookup == null ? 43 : ((Object)$carDriverLookup).hashCode());
        return result;
    }

    public String toString() {
        return "StatisticResult(sessionType=" + this.getSessionType() + ", track=" + this.getTrack() + ", serverName=" + this.getServerName() + ", bestLap=" + this.getBestLap() + ", wetSession=" + this.isWetSession() + ", minStopTime=" + this.getMinStopTime() + ", drivers=" + this.getDrivers() + ", carDriverLookup=" + this.getCarDriverLookup() + ")";
    }
}

