/*
 * Decompiled with CFR 0.152.
 */
package de.teamholycow.acc.resultserver.model.statistic;

import de.teamholycow.acc.resultserver.model.statistic.DriverPitStop;
import java.util.ArrayList;
import java.util.List;

public class DriverStatistic {
    private int laps;
    private long optimalTime;
    private long bestTime;
    private long avgTime;
    private int slowLaps;
    private int invalidLaps;
    private List<DriverPitStop> pitStops = new ArrayList<DriverPitStop>();
    private Double consistency;
    private Double consistencyPercentage;

    public int getValidLaps() {
        return this.laps - this.invalidLaps;
    }

    public long getPitStopTime() {
        return this.getPitStops().stream().mapToLong(t -> t.getStopTime() - t.getDmgTime()).sum();
    }

    public long getDamageTime() {
        return this.getPitStops().stream().mapToLong(DriverPitStop::getDmgTime).sum();
    }

    public int getLaps() {
        return this.laps;
    }

    public long getOptimalTime() {
        return this.optimalTime;
    }

    public long getBestTime() {
        return this.bestTime;
    }

    public long getAvgTime() {
        return this.avgTime;
    }

    public int getSlowLaps() {
        return this.slowLaps;
    }

    public int getInvalidLaps() {
        return this.invalidLaps;
    }

    public List<DriverPitStop> getPitStops() {
        return this.pitStops;
    }

    public Double getConsistency() {
        return this.consistency;
    }

    public Double getConsistencyPercentage() {
        return this.consistencyPercentage;
    }

    public void setLaps(int laps) {
        this.laps = laps;
    }

    public void setOptimalTime(long optimalTime) {
        this.optimalTime = optimalTime;
    }

    public void setBestTime(long bestTime) {
        this.bestTime = bestTime;
    }

    public void setAvgTime(long avgTime) {
        this.avgTime = avgTime;
    }

    public void setSlowLaps(int slowLaps) {
        this.slowLaps = slowLaps;
    }

    public void setInvalidLaps(int invalidLaps) {
        this.invalidLaps = invalidLaps;
    }

    public void setPitStops(List<DriverPitStop> pitStops) {
        this.pitStops = pitStops;
    }

    public void setConsistency(Double consistency) {
        this.consistency = consistency;
    }

    public void setConsistencyPercentage(Double consistencyPercentage) {
        this.consistencyPercentage = consistencyPercentage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DriverStatistic)) {
            return false;
        }
        DriverStatistic other = (DriverStatistic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLaps() != other.getLaps()) {
            return false;
        }
        if (this.getOptimalTime() != other.getOptimalTime()) {
            return false;
        }
        if (this.getBestTime() != other.getBestTime()) {
            return false;
        }
        if (this.getAvgTime() != other.getAvgTime()) {
            return false;
        }
        if (this.getSlowLaps() != other.getSlowLaps()) {
            return false;
        }
        if (this.getInvalidLaps() != other.getInvalidLaps()) {
            return false;
        }
        Double this$consistency = this.getConsistency();
        Double other$consistency = other.getConsistency();
        if (this$consistency == null ? other$consistency != null : !((Object)this$consistency).equals(other$consistency)) {
            return false;
        }
        Double this$consistencyPercentage = this.getConsistencyPercentage();
        Double other$consistencyPercentage = other.getConsistencyPercentage();
        if (this$consistencyPercentage == null ? other$consistencyPercentage != null : !((Object)this$consistencyPercentage).equals(other$consistencyPercentage)) {
            return false;
        }
        List<DriverPitStop> this$pitStops = this.getPitStops();
        List<DriverPitStop> other$pitStops = other.getPitStops();
        return !(this$pitStops == null ? other$pitStops != null : !((Object)this$pitStops).equals(other$pitStops));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DriverStatistic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLaps();
        long $optimalTime = this.getOptimalTime();
        result = result * 59 + (int)($optimalTime >>> 32 ^ $optimalTime);
        long $bestTime = this.getBestTime();
        result = result * 59 + (int)($bestTime >>> 32 ^ $bestTime);
        long $avgTime = this.getAvgTime();
        result = result * 59 + (int)($avgTime >>> 32 ^ $avgTime);
        result = result * 59 + this.getSlowLaps();
        result = result * 59 + this.getInvalidLaps();
        Double $consistency = this.getConsistency();
        result = result * 59 + ($consistency == null ? 43 : ((Object)$consistency).hashCode());
        Double $consistencyPercentage = this.getConsistencyPercentage();
        result = result * 59 + ($consistencyPercentage == null ? 43 : ((Object)$consistencyPercentage).hashCode());
        List<DriverPitStop> $pitStops = this.getPitStops();
        result = result * 59 + ($pitStops == null ? 43 : ((Object)$pitStops).hashCode());
        return result;
    }

    public String toString() {
        return "DriverStatistic(laps=" + this.getLaps() + ", optimalTime=" + this.getOptimalTime() + ", bestTime=" + this.getBestTime() + ", avgTime=" + this.getAvgTime() + ", slowLaps=" + this.getSlowLaps() + ", invalidLaps=" + this.getInvalidLaps() + ", pitStops=" + this.getPitStops() + ", consistency=" + this.getConsistency() + ", consistencyPercentage=" + this.getConsistencyPercentage() + ")";
    }
}

