/*
 * Decompiled with CFR 0.152.
 */
package de.teamholycow.acc.resultserver;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.teamholycow.acc.resultserver.model.json.JsonResult;
import de.teamholycow.acc.resultserver.model.penalty.LeaguePenalty;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonParser {
    private static final Logger log = LoggerFactory.getLogger(JsonParser.class);
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    public JsonResult parse(String fileName) throws IOException {
        return this.parse(fileName, true);
    }

    public JsonResult parse(String fileName, boolean createReadableJson) throws IOException {
        String line;
        BufferedReader reader = Files.newBufferedReader(Paths.get(fileName, new String[0]), StandardCharsets.UTF_16LE);
        Writer writer = createReadableJson ? Files.newBufferedWriter(Paths.get(fileName.replace("json", "aencoded.json"), new String[0]), new OpenOption[0]) : StringWriter.nullWriter();
        StringBuilder buffer = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            writer.write(line);
        }
        reader.close();
        writer.close();
        JsonResult jsonResult = (JsonResult)this.objectMapper.readValue(buffer.toString(), JsonResult.class);
        log.info("{}", (Object)jsonResult);
        return jsonResult;
    }

    public List<LeaguePenalty> parseLeaguePenalties(String filename) throws IOException {
        List penalties = (List)this.objectMapper.readValue(new File(filename), (TypeReference)new TypeReference<List<LeaguePenalty>>(){});
        log.info("{}", (Object)penalties);
        return penalties;
    }
}

