/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dao.mongo.links;

import de.taimos.dao.AEntity;
import de.taimos.dao.mongo.links.AReferenceableEntity;

public class DocumentLink<T extends AReferenceableEntity<T>> {
    private Class<T> targetClass;
    private String objectId;
    private String label;

    public DocumentLink() {
    }

    public DocumentLink(T object) {
        this(object.getClass(), ((AEntity)object).getId(), ((AReferenceableEntity)object).getLabel());
    }

    public DocumentLink(Class<T> targetClass, String objectId, String label) {
        this.targetClass = targetClass;
        this.objectId = objectId;
        this.label = label;
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(Class<T> targetClass) {
        this.targetClass = targetClass;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return String.format("%s [%s@%s]", this.label, this.objectId, this.targetClass.getSimpleName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.objectId == null ? 0 : this.objectId.hashCode());
        result = 31 * result + (this.targetClass == null ? 0 : this.targetClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentLink)) {
            return false;
        }
        DocumentLink other = (DocumentLink)obj;
        if (this.objectId == null ? other.objectId != null : !this.objectId.equals(other.objectId)) {
            return false;
        }
        return !(this.targetClass == null ? other.targetClass != null : !this.targetClass.equals(other.targetClass));
    }
}

