/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dao.mongo;

import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.util.Scanner;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MongoDBInit {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDBInit.class);
    @Autowired
    private MongoClient mongo;
    private boolean enabled = false;

    @PostConstruct
    public void initDatabase() {
        if (!this.enabled) {
            return;
        }
        LOGGER.info("initializing MongoDB");
        String dbName = System.getProperty("mongodb.name");
        if (dbName == null) {
            throw new RuntimeException("Missing database name; Set system property 'mongodb.name'");
        }
        MongoDatabase db = this.mongo.getDatabase(dbName);
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources("classpath*:mongodb/*.ndjson");
            LOGGER.info("Scanning for collection data");
            for (Resource res : resources) {
                String filename = res.getFilename();
                String collection = filename.substring(0, filename.length() - 7);
                LOGGER.info("Found collection file: " + collection);
                MongoCollection dbCollection = db.getCollection(collection, DBObject.class);
                try (Scanner scan = new Scanner(res.getInputStream());){
                    int lines = 0;
                    while (scan.hasNextLine()) {
                        String json = scan.nextLine();
                        Object parse = JSON.parse((String)json);
                        if (!(parse instanceof DBObject)) {
                            LOGGER.error("Invalid object found: " + parse);
                            throw new RuntimeException("Invalid object");
                        }
                        DBObject dbObject = (DBObject)parse;
                        dbCollection.insertOne((Object)dbObject);
                        ++lines;
                    }
                    LOGGER.info("Imported " + lines + " objects into collection " + collection);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error importing objects", e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

