/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dao.mongo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mongodb.DB;
import de.taimos.dao.JodaMapping;
import org.joda.time.DateTime;
import org.jongo.Jongo;
import org.jongo.marshall.jackson.JacksonMapper;

public final class JongoFactory {
    private JongoFactory() {
    }

    public static Jongo createDefault(DB db) {
        JacksonMapper.Builder builder = new JacksonMapper.Builder();
        builder.enable(MapperFeature.AUTO_DETECT_GETTERS);
        builder.addSerializer(DateTime.class, (JsonSerializer)new JodaMapping.MongoDateTimeSerializer());
        builder.addDeserializer(DateTime.class, (JsonDeserializer)new JodaMapping.MongoDateTimeDeserializer());
        builder.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        builder.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        return new Jongo(db, builder.build());
    }
}

