package de.taimos.dao;

/*
 * #%L Spring DAO Mongo %% Copyright (C) 2013 Taimos GmbH %% Licensed under the Apache License, Version 2.0 (the "License"); you may not use
 * this file except in compliance with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License. #L%
 */

import java.io.IOException;
import java.util.Date;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * Copyright 2015 Hoegernet<br>
 * <br>
 * (De-)Serializer for Jodatime
 * 
 * @author Thorsten Hoeger
 *
 */
public class JodaMapping {
	
	public static class MongoDateTimeSerializer extends JsonSerializer<DateTime> {
		
		@Override
		public void serialize(DateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
			jgen.writeObject(value.toDate());
		}
		
	}
	
	public static class MongoDateTimeDeserializer extends JsonDeserializer<DateTime> {
		
		@Override
		public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
			Object object = jp.getEmbeddedObject();
			if (object instanceof Date) {
				Date date = (Date) object;
				return new DateTime(date.getTime(), DateTimeZone.forTimeZone(ctxt.getTimeZone()));
			}
			return new DateTime(object);
		}
		
	}
	
}
