/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dao.mongo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoClient;
import de.taimos.dao.AEntity;
import de.taimos.dao.ICrudDAO;
import de.taimos.dao.JodaMapping;
import de.taimos.dao.mongo.ConverterIterable;
import de.taimos.dao.mongo.IObjectConverter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.jongo.Find;
import org.jongo.Jongo;
import org.jongo.MongoCollection;
import org.jongo.MongoCursor;
import org.jongo.marshall.jackson.JacksonMapper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMongoDAO<T extends AEntity>
implements ICrudDAO<T> {
    @Autowired
    private MongoClient mongo;
    private Jongo jongo;
    protected MongoCollection collection;

    @PostConstruct
    public final void init() {
        String dbName = System.getProperty("mongodb.name");
        if (dbName == null) {
            throw new RuntimeException("Missing database name; Set system property 'mongodb.name'");
        }
        DB db = this.mongo.getDB(dbName);
        this.jongo = this.createJongo(db);
        this.collection = this.jongo.getCollection(this.getCollectionName());
        this.addIndexes();
    }

    protected void addIndexes() {
    }

    protected final void addIndex(String field, boolean asc, boolean background) {
        String options = background ? "{background:true}" : "{}";
        String dir = asc ? "1" : "-1";
        this.collection.ensureIndex("{" + field + ":" + dir + "}", options);
    }

    protected final void addTTLIndex(String field, int ttl) {
        if (ttl <= 0) {
            throw new IllegalArgumentException("TTL must be positive");
        }
        this.collection.ensureIndex("{" + field + ":1}", "{expireAfterSeconds: " + ttl + "}");
    }

    protected String getCollectionName() {
        return this.getEntityClass().getSimpleName();
    }

    protected abstract Class<T> getEntityClass();

    protected final <R> Iterable<R> mapReduce(String map, String reduce, IObjectConverter<R> conv) {
        return this.mapReduce(map, reduce, null, conv);
    }

    protected final <R> Iterable<R> mapReduce(String map, String reduce, DBObject query, IObjectConverter<R> conv) {
        MapReduceOutput mr = this.collection.getDBCollection().mapReduce(map, reduce, null, MapReduceCommand.OutputType.INLINE, query);
        return new ConverterIterable<R>(mr.results().iterator(), conv);
    }

    @Override
    public final List<T> findList() {
        MongoCursor as = this.collection.find().sort("{_id:1}").as(this.getEntityClass());
        return this.convertIterable((Iterable<T>)as);
    }

    protected final List<T> convertIterable(Iterable<T> as) {
        ArrayList<AEntity> objects = new ArrayList<AEntity>();
        for (AEntity mp : as) {
            objects.add(mp);
        }
        return objects;
    }

    protected final List<T> findByQuery(String query, Object ... params) {
        return this.findSortedByQuery(query, null, params);
    }

    protected final List<T> findSortedByQuery(String query, String sort, Object ... params) {
        Find find = this.collection.find(query, params);
        if (sort != null && !sort.isEmpty()) {
            find.sort(sort);
        }
        return this.convertIterable((Iterable<T>)find.as(this.getEntityClass()));
    }

    protected final T findFirstByQuery(String query, String sort, Object ... params) {
        MongoCursor as;
        Iterator iterator;
        Find find = this.collection.find(query, params);
        if (sort != null && !sort.isEmpty()) {
            find.sort(sort);
        }
        if ((iterator = (as = find.limit(1).as(this.getEntityClass())).iterator()).hasNext()) {
            return (T)((AEntity)iterator.next());
        }
        return null;
    }

    @Override
    public final T findById(String id) {
        return (T)((AEntity)this.collection.findOne(new ObjectId(id)).as(this.getEntityClass()));
    }

    @Override
    public final T save(T object) {
        this.beforeSave(object);
        this.collection.save(object);
        this.afterSave(object);
        return object;
    }

    protected void afterSave(T object) {
    }

    protected void beforeSave(T object) {
    }

    @Override
    public final void delete(T object) {
        this.delete(((AEntity)object).getId());
    }

    @Override
    public final void delete(String id) {
        this.beforeDelete(id);
        this.collection.remove(new ObjectId(id));
        this.afterDelete(id);
    }

    protected void beforeDelete(String id) {
    }

    protected void afterDelete(String id) {
    }

    protected Jongo createJongo(DB db) {
        JacksonMapper.Builder builder = new JacksonMapper.Builder();
        builder.enable(MapperFeature.AUTO_DETECT_GETTERS);
        builder.addSerializer(DateTime.class, (JsonSerializer)new JodaMapping.MongoDateTimeSerializer());
        builder.addDeserializer(DateTime.class, (JsonDeserializer)new JodaMapping.MongoDateTimeDeserializer());
        builder.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        builder.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        return new Jongo(db, builder.build());
    }
}

