/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dao.hibernate;

import de.taimos.dao.IEntity;
import de.taimos.dao.IEntityDAO;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.springframework.transaction.annotation.Transactional;

public abstract class EntityDAOHibernate<E extends IEntity<I>, I>
implements IEntityDAO<E, I> {
    @PersistenceContext
    protected EntityManager entityManager;

    @Override
    @Transactional
    public E save(E element) {
        return (E)((IEntity)this.entityManager.merge(element));
    }

    @Override
    @Transactional
    public void delete(E element) {
        this.entityManager.remove(this.entityManager.merge(element));
    }

    @Override
    @Transactional
    public void deleteById(I id) {
        E element = this.findById(id);
        if (element == null) {
            throw new EntityNotFoundException();
        }
        this.entityManager.remove(element);
    }

    @Override
    public E findById(I id) {
        return (E)((IEntity)this.entityManager.find(this.getEntityClass(), id));
    }

    @Override
    public List<E> findList(int first, int max) {
        TypedQuery query = this.entityManager.createQuery(this.getFindListQuery(), this.getEntityClass());
        if (first >= 0) {
            query.setFirstResult(first);
        }
        if (max >= 0) {
            query.setMaxResults(max);
        }
        return query.getResultList();
    }

    @Override
    public List<E> findList() {
        return this.findList(-1, -1);
    }

    protected final E findByQuery(String query, Object ... params) {
        List<E> list = this.findListByQuery(query, params);
        if (list.size() == 1) {
            return (E)((IEntity)list.get(0));
        }
        return null;
    }

    protected final Object[] findGenericByQuery(String query, Object ... params) {
        List<Object[]> list = this.findGenericListByQuery(query, params);
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    protected final List<E> findListByQuery(String query, Object ... params) {
        return this.findListByQueryLimit(query, -1, -1, params);
    }

    protected final List<Object[]> findGenericListByQuery(String query, Object ... params) {
        return this.findGenericListByQueryLimit(query, -1, -1, params);
    }

    protected final List<Object[]> findGenericListByQueryLimit(String query, int first, int max, Object ... params) {
        return this.findListByQueryLimit(query, Object[].class, first, max, params);
    }

    protected final List<E> findListByQueryLimit(String query, int first, int max, Object ... params) {
        return this.findListByQueryLimit(query, this.getEntityClass(), first, max, params);
    }

    private <T> List<T> findListByQueryLimit(String query, Class<T> clazz, int first, int max, Object ... params) {
        TypedQuery tq = this.entityManager.createQuery(query, clazz);
        for (int i = 0; i < params.length; ++i) {
            tq.setParameter(i + 1, params[i]);
        }
        if (first >= 0) {
            tq.setFirstResult(first);
        }
        if (max >= 0) {
            tq.setMaxResults(max);
        }
        return tq.getResultList();
    }

    protected String getIdField() {
        return "id";
    }

    protected String getFindListQuery() {
        return "FROM " + this.getEntityClass().getSimpleName();
    }
}

