/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dao.hibernate;

import de.taimos.dao.EntityDAO;
import de.taimos.dao.IEntity;
import de.taimos.dao.exceptions.ConstraintException;
import de.taimos.dao.exceptions.DAOException;
import de.taimos.dao.exceptions.EntityNotFoundException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.transaction.annotation.Transactional;

public abstract class EntityDAOHibernate<E extends IEntity<I>, I>
implements EntityDAO<E, I> {
    @PersistenceContext
    protected EntityManager entityManager;

    @Override
    @Transactional
    public E save(E element) {
        try {
            return (E)((IEntity)this.entityManager.merge(element));
        }
        catch (ConstraintViolationException e) {
            throw new ConstraintException(e);
        }
        catch (HibernateException e) {
            throw new DAOException(e);
        }
    }

    @Override
    @Transactional
    public void delete(E element) {
        try {
            this.entityManager.remove(this.entityManager.merge(element));
        }
        catch (HibernateException e) {
            throw new DAOException(e);
        }
    }

    @Override
    public void deleteById(I id) {
        try {
            E element = this.findById(id);
            if (element == null) {
                throw new EntityNotFoundException();
            }
            this.entityManager.remove(element);
        }
        catch (HibernateException e) {
            throw new DAOException(e);
        }
    }

    @Override
    public E findById(I id) {
        try {
            return (E)((IEntity)this.entityManager.find(this.getEntityClass(), id));
        }
        catch (HibernateException e) {
            throw new DAOException(e);
        }
    }

    @Override
    public List<E> findList() {
        try {
            TypedQuery query = this.entityManager.createQuery(this.getFindListQuery(), this.getEntityClass());
            return query.getResultList();
        }
        catch (HibernateException e) {
            throw new DAOException(e);
        }
    }

    protected String getIdField() {
        return "id";
    }

    protected E findByQuery(String query, Object ... params) {
        try {
            List<E> list = this.findListByQuery(query, params);
            if (list.size() == 1) {
                return (E)((IEntity)list.get(0));
            }
            return null;
        }
        catch (HibernateException e) {
            throw new DAOException(e);
        }
    }

    protected List<E> findListByQuery(String query, Object ... params) {
        try {
            TypedQuery tq = this.entityManager.createQuery(query, this.getEntityClass());
            for (int i = 0; i < params.length; ++i) {
                tq.setParameter(i + 1, params[i]);
            }
            return tq.getResultList();
        }
        catch (HibernateException e) {
            throw new DAOException(e);
        }
    }

    protected String getFindListQuery() {
        return "FROM " + this.getEntityClass().getSimpleName();
    }
}

