/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.taimos.springcxfdaemon.MapperFactory;
import java.io.IOException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSocketAdapter
extends WebSocketAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientSocketAdapter.class);
    private ObjectMapper mapper = MapperFactory.createDefault();

    public void modifyRequest(ClientUpgradeRequest req) {
    }

    public final void sendObjectToSocket(Object o) {
        Session sess = this.getSession();
        if (sess != null) {
            String json;
            try {
                json = this.mapper.writeValueAsString(o);
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Failed to serialize object", (Throwable)e);
                return;
            }
            sess.getRemote().sendString(json, new WriteCallback(){

                public void writeSuccess() {
                    LOGGER.info("Send data to socket");
                }

                public void writeFailed(Throwable x) {
                    LOGGER.error("Error sending message to socket", x);
                }
            });
        }
    }

    protected final <T> T readMessage(String message, Class<T> clazz) {
        if (message == null || message.isEmpty()) {
            LOGGER.info("Got empty session data");
            return null;
        }
        try {
            return (T)this.mapper.readValue(message, clazz);
        }
        catch (IOException e1) {
            LOGGER.info("Got invalid session data", (Throwable)e1);
            return null;
        }
    }
}

