/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon.security;

import de.taimos.restutils.RESTAssert;
import de.taimos.springcxfdaemon.monitoring.InvocationInstance;
import java.util.UUID;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SecurityContextBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public final SecurityContext getSC() {
        return this.getContext().getSecurityContext();
    }

    public final void assertSC() {
        if (this.getSC() == null || this.getSC().getUserPrincipal() == null) {
            throw new NotAuthorizedException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Invalid credentials or session").build());
        }
    }

    public final void assertLoggedIn() {
        this.assertSC();
    }

    public final String getUser() {
        SecurityContext sc = this.getSC();
        if (sc != null && sc.getUserPrincipal() != null) {
            return sc.getUserPrincipal().getName();
        }
        return null;
    }

    public final boolean hasRole(String role) {
        SecurityContext sc = this.getSC();
        if (sc != null) {
            return sc.isUserInRole(role);
        }
        return false;
    }

    public final UUID requestId() {
        InvocationInstance ii = (InvocationInstance)this.getContext().getContent(InvocationInstance.class);
        RESTAssert.assertNotNull((Object)ii, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        return ii.getMessageId();
    }

    public final boolean isLoggedIn() {
        return this.getUser() != null;
    }

    private MessageContext getContext() {
        return new MessageContextImpl(PhaseInterceptorChain.getCurrentMessage());
    }
}

