/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon.security;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=2000)
public class RolesFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolesFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Message m = JAXRSUtils.getCurrentMessage();
        Method method = (Method)m.get((Object)"org.apache.cxf.resource.method");
        Object[] needed = this.searchRoles(method);
        if (needed.length == 0) {
            LOGGER.debug("No roles needed");
            return;
        }
        LOGGER.debug("Needs: {}", (Object)Joiner.on((String)",").join(needed));
        SecurityContext securityContext = (SecurityContext)m.get(SecurityContext.class);
        if (securityContext != null) {
            for (Object need : needed) {
                if (!securityContext.isUserInRole((String)need)) continue;
                LOGGER.debug("Passed with role {}", need);
                return;
            }
        }
        String text = "Missing at least one of the following roles: " + Joiner.on((String)",").join(needed);
        requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)text).build());
    }

    private String[] searchRoles(Method method) {
        Class<?>[] interfaces;
        String[] needs;
        if (method == null) {
            return new String[0];
        }
        if (method.isAnnotationPresent(RolesAllowed.class)) {
            return method.getAnnotation(RolesAllowed.class).value();
        }
        if (method.getDeclaringClass().getInterfaces().length != 0 && (needs = this.searchClassArray(interfaces = method.getDeclaringClass().getInterfaces(), method)).length > 0) {
            return needs;
        }
        return new String[0];
    }

    private String[] searchClassArray(Class<?>[] classes, Method m) {
        for (Class<?> iface : classes) {
            try {
                Method iMeth = iface.getMethod(m.getName(), m.getParameterTypes());
                if (!iMeth.isAnnotationPresent(RolesAllowed.class)) continue;
                return iMeth.getAnnotation(RolesAllowed.class).value();
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        return new String[0];
    }
}

