/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon.websocket;

import de.taimos.springcxfdaemon.websocket.WebSocket;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class WebSocketContextHandler
extends ServletContextHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketContextHandler.class);
    @Value(value="${websocket.baseuri:/websocket}")
    private String baseURI;
    @Autowired
    private ListableBeanFactory beanFactory;

    @PostConstruct
    public void init() {
        String[] socketBeans;
        this.setContextPath(this.baseURI);
        for (String sb : socketBeans = this.beanFactory.getBeanNamesForAnnotation(WebSocket.class)) {
            WebSocket ann = (WebSocket)this.beanFactory.findAnnotationOnBean(sb, WebSocket.class);
            LOGGER.info("Found bean {} for path {}", (Object)sb, (Object)ann.pathSpec());
            this.addServlet(new ServletHolder((Servlet)this.createServletForBeanName(sb)), ann.pathSpec());
        }
    }

    private WebSocketServlet createServletForBeanName(final String beanName) {
        return new WebSocketServlet(){
            private static final long serialVersionUID = 1L;

            public void configure(WebSocketServletFactory factory) {
                LOGGER.info("Configuring WebSocket Servlet for {}", (Object)beanName);
                factory.getPolicy().setIdleTimeout(10000L);
                factory.setCreator(new WebSocketCreator(){

                    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
                        return WebSocketContextHandler.this.beanFactory.getBean(beanName);
                    }
                });
            }
        };
    }
}

