/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.taimos.daemon.spring.SpringDaemonTestRunner;
import de.taimos.httputils.HTTPRequest;
import de.taimos.httputils.WS;
import de.taimos.springcxfdaemon.MapperFactory;
import java.io.IOException;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.http.HttpResponse;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;

@RunWith(value=SpringDaemonTestRunner.class)
public abstract class APITest {
    private static final String APPLICATION_JSON = "application/json";
    @Value(value="${server.url:http://localhost:${jaxrs.bindport:${svc.port:8080}}}")
    private String serverURL;

    protected final String getServerURL() {
        return this.serverURL;
    }

    protected final HTTPRequest request(String path) {
        return WS.url((String)(this.serverURL + path));
    }

    protected final void assertOK(HttpResponse res) {
        Assert.assertTrue((String)String.format("Expected OK - was %s", WS.getStatus((HttpResponse)res)), (boolean)WS.isStatusOK((HttpResponse)res));
    }

    protected final void assertStatus(HttpResponse res, Response.Status status) {
        Assert.assertTrue((String)String.format("Expected %s - was %s", status.getStatusCode(), WS.getStatus((HttpResponse)res)), (WS.getStatus((HttpResponse)res) == status.getStatusCode() ? 1 : 0) != 0);
    }

    protected final void assertOK(Response res) {
        Assert.assertTrue((String)String.format("Expected OK - was %s", res.getStatus()), (res.getStatus() >= 200 && res.getStatus() <= 299 ? 1 : 0) != 0);
    }

    protected final void assertStatus(Response res, Response.Status status) {
        Assert.assertTrue((String)String.format("Expected %s - was %s", status.getStatusCode(), res.getStatus()), (res.getStatus() == status.getStatusCode() ? 1 : 0) != 0);
    }

    protected <T> T read(HttpResponse res, Class<T> clazz) {
        try {
            return (T)MapperFactory.createDefault().readValue(res.getEntity().getContent(), clazz);
        }
        catch (IOException | IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Object> readMap(HttpResponse res) {
        return this.read(res, Map.class);
    }

    protected HTTPRequest jsonBody(HTTPRequest req, Object o) {
        try {
            String json = MapperFactory.createDefault().writeValueAsString(o);
            return req.contentType(APPLICATION_JSON).body(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

