/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon.providers;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;

@Provider
public abstract class AuthorizationProvider
implements ContainerRequestFilter {
    public final void filter(ContainerRequestContext requestContext) throws IOException {
        String auth;
        int index;
        String type;
        SecurityContext sc;
        Message m = JAXRSUtils.getCurrentMessage();
        HttpHeadersImpl head = new HttpHeadersImpl(m);
        String authHeader = head.getHeaderString("Authorization");
        if (authHeader != null && !authHeader.isEmpty() && authHeader.indexOf(" ") != -1 && (sc = this.handleAuthHeader(requestContext, m, type = authHeader.substring(0, index = authHeader.indexOf(" ")), auth = authHeader.substring(index + 1))) != null) {
            m.put(SecurityContext.class, (Object)sc);
            return;
        }
        SecurityContext sc2 = this.handleOther(requestContext, m, (HttpHeaders)head);
        if (sc2 != null) {
            m.put(SecurityContext.class, (Object)sc2);
            return;
        }
        if (this.isAuthorizationMandatory()) {
            this.abortUnauthorized(requestContext);
        }
    }

    protected final void abortUnauthorized(ContainerRequestContext requestContext) {
        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }

    protected abstract boolean isAuthorizationMandatory();

    protected abstract SecurityContext handleAuthHeader(ContainerRequestContext var1, Message var2, String var3, String var4);

    protected abstract SecurityContext handleOther(ContainerRequestContext var1, Message var2, HttpHeaders var3);

    protected static SecurityContext createSC(String user, String ... roles) {
        Subject subject = new Subject();
        SimplePrincipal principal = new SimplePrincipal(user);
        subject.getPrincipals().add((Principal)principal);
        if (roles != null) {
            for (String role : roles) {
                subject.getPrincipals().add((Principal)new SimplePrincipal(role));
            }
        }
        return new DefaultSecurityContext((Principal)principal, subject);
    }
}

