/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import de.taimos.springcxfdaemon.MapperFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class JacksonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private ObjectMapper mapper = MapperFactory.createDefault();

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.getSubtype().equals("json") || mediaType.getSubtype().endsWith("+json");
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.mapper.writeValueAsBytes(t));
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.getSubtype().equals("json") || mediaType.getSubtype().endsWith("+json");
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        if (genericType.equals(null)) {
            return this.mapper.readValue(entityStream, type);
        }
        return this.mapper.readValue(entityStream, TypeFactory.defaultInstance().constructType(genericType));
    }
}

