/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon.monitoring;

import de.taimos.springcxfdaemon.monitoring.InvocationInstance;
import java.lang.reflect.Method;
import java.util.UUID;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MonitoringFeature
extends AbstractFeature {
    private static final String MDC_METHOD = "calledMethod";
    private static final String MDC_CLASS = "calledClass";
    private static final String MDC_REQUEST = "requestId";
    private static final int DURATION_THRESHOLD = 10000;
    private static final String CXF_METHOD = "org.apache.cxf.resource.method";
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringFeature.class);

    public void initialize(Server server, Bus bus) {
        server.getEndpoint().getInInterceptors().add(new AbstractPhaseInterceptor<Message>("receive"){

            public void handleMessage(Message message) {
                MonitoringFeature.this.startMessage(message);
            }
        });
        server.getEndpoint().getInInterceptors().add(new AbstractPhaseInterceptor<Message>("pre-invoke"){

            public void handleMessage(Message message) {
                MonitoringFeature.this.invokeMessage(message);
            }
        });
        server.getEndpoint().getOutInterceptors().add(new AbstractPhaseInterceptor<Message>("pre-protocol"){

            public void handleMessage(Message message) {
                MonitoringFeature.this.endMessage(message);
            }
        });
    }

    void startMessage(Message m) {
        UUID messageId = UUID.randomUUID();
        InvocationInstance i = new InvocationInstance(messageId);
        i.start();
        m.setContent(InvocationInstance.class, (Object)i);
        m.getExchange().put(InvocationInstance.class, (Object)i);
        MDC.put((String)MDC_REQUEST, (String)i.getMessageId().toString());
    }

    void endMessage(Message m) {
        InvocationInstance i = this.stopInstance(m);
        if (i.getDuration() > 10000L) {
            LOGGER.warn("SLOW RESPONSE: " + i.toString());
        }
    }

    private InvocationInstance stopInstance(Message m) {
        InvocationInstance i = (InvocationInstance)m.getExchange().get(InvocationInstance.class);
        i.stop();
        LOGGER.info(i.toString());
        MDC.remove((String)MDC_REQUEST);
        MDC.remove((String)MDC_CLASS);
        MDC.remove((String)MDC_METHOD);
        return i;
    }

    void invokeMessage(Message message) {
        InvocationInstance i = (InvocationInstance)message.getContent(InvocationInstance.class);
        Method method = (Method)message.get((Object)CXF_METHOD);
        if (method != null && i != null) {
            i.setCalledMethod(method);
            MDC.put((String)MDC_CLASS, (String)i.getCalledClass());
            MDC.put((String)MDC_METHOD, (String)i.getCalledMethodName());
        }
    }
}

