/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon.monitoring;

import java.lang.reflect.Method;
import java.util.UUID;

public class InvocationInstance {
    private final UUID messageId;
    private long startNano;
    private long endNano;
    private long duration;
    private Method calledMethod;
    private String calledClass;
    private String calledMethodName;

    public InvocationInstance(UUID messageId) {
        this.messageId = messageId;
    }

    public void start() {
        this.startNano = System.nanoTime();
    }

    public void stop() {
        this.endNano = System.nanoTime();
        this.duration = this.endNano - this.startNano;
        this.duration /= 1000000L;
    }

    public String toString() {
        String msgString = "Message %s was %s ms inflight. Access was to class '%s' and method '%s'";
        return String.format("Message %s was %s ms inflight. Access was to class '%s' and method '%s'", this.getMessageId(), this.getDuration(), this.getCalledClass(), this.getCalledMethod());
    }

    public long getStartNano() {
        return this.startNano;
    }

    public long getEndNano() {
        return this.endNano;
    }

    public Method getCalledMethod() {
        return this.calledMethod;
    }

    public void setCalledMethod(Method calledMethod) {
        this.calledMethod = calledMethod;
        if (calledMethod != null && calledMethod.getDeclaringClass() != null) {
            this.calledMethodName = calledMethod.getName();
            this.calledClass = calledMethod.getDeclaringClass().getCanonicalName();
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public UUID getMessageId() {
        return this.messageId;
    }

    public String getCalledClass() {
        return this.calledClass;
    }

    public String getCalledMethodName() {
        return this.calledMethodName;
    }
}

