/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon;

import de.taimos.daemon.DaemonLifecycleAdapter;
import de.taimos.daemon.DaemonStarter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public abstract class SpringDaemonAdapter
extends DaemonLifecycleAdapter {
    private static AbstractXmlApplicationContext context;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void doStart() throws Exception {
        super.doStart();
        try {
            this.doBeforeSpringStart();
        }
        catch (Exception e) {
            throw new RuntimeException("Before spring failed", e);
        }
        try {
            context = this.createSpringContext();
            String[] profiles = System.getProperty("profiles", "prod").split(",");
            context.getEnvironment().setActiveProfiles(profiles);
            PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
            configurer.setProperties(DaemonStarter.getDaemonProperties());
            context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
            context.setConfigLocation(this.getSpringResource());
            context.refresh();
        }
        catch (Exception e) {
            throw new RuntimeException("Spring context failed", e);
        }
        try {
            this.doAfterSpringStart();
        }
        catch (Exception e) {
            throw new RuntimeException("After spring failed", e);
        }
    }

    protected void doAfterSpringStart() {
    }

    protected void doBeforeSpringStart() {
    }

    protected void doAfterSpringStop() {
    }

    protected void doBeforeSpringStop() {
    }

    protected AbstractXmlApplicationContext createSpringContext() {
        return new ClassPathXmlApplicationContext();
    }

    protected String getSpringResource() {
        return "spring/beans.xml";
    }

    public void doStop() throws Exception {
        try {
            this.doBeforeSpringStop();
        }
        catch (Exception e) {
            throw new RuntimeException("Before spring stop failed", e);
        }
        try {
            context.stop();
        }
        catch (Exception e) {
            throw new RuntimeException("spring stop failed", e);
        }
        try {
            this.doAfterSpringStop();
        }
        catch (Exception e) {
            throw new RuntimeException("After spring stop failed", e);
        }
        super.doStop();
    }

    public Map<String, String> loadProperties() {
        Map props = super.loadProperties();
        if (System.getProperty("servicePackage") == null) {
            props.put("servicePackage", ((Object)((Object)this)).getClass().getPackage().getName());
        }
        return props;
    }

    public static ApplicationContext getContext() {
        return context;
    }
}

