/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon;

import de.taimos.springcxfdaemon.SpringTest;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;

public class SpringDaemonTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger logger = LoggerFactory.getLogger(SpringDaemonTestRunner.class);
    private static SpringTest springTest;

    public SpringDaemonTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.configureLogging();
    }

    private void configureLogging() {
        org.apache.log4j.Logger.getRootLogger().removeAllAppenders();
        ConsoleAppender console = new ConsoleAppender();
        console.setName("CONSOLE");
        console.setLayout((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c %x - %m%n"));
        console.setTarget("System.out");
        console.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender((Appender)console);
        org.apache.log4j.Logger.getRootLogger().setLevel(Level.INFO);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        final Statement invoker = super.methodInvoker(method, test);
        return new Statement(){

            public void evaluate() throws Throwable {
                invoker.evaluate();
            }
        };
    }

    protected Statement withAfterClasses(Statement statement) {
        final Statement next = super.withAfterClasses(statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                next.evaluate();
                springTest.stop();
            }
        };
    }

    protected Statement withBeforeClasses(Statement statement) {
        final Statement next = super.withBeforeClasses(statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                if (!SpringDaemonTestRunner.this.getTestClass().getJavaClass().isAnnotationPresent(RunnerConfiguration.class)) {
                    throw new RuntimeException("Missing @RunnerConfiguration");
                }
                final RunnerConfiguration cfgClass = SpringDaemonTestRunner.this.getTestClass().getJavaClass().getAnnotation(RunnerConfiguration.class);
                final RunnerConfig cfg = cfgClass.config().newInstance();
                cfg.addProperty("serviceName", cfgClass.svc());
                cfg.addProperty("profiles", "test");
                cfg.addProperty("developmentMode", "true");
                try {
                    springTest = new SpringTest(){

                        @Override
                        protected String getServiceName() {
                            return cfgClass.svc();
                        }

                        @Override
                        protected void fillProperties(Map<String, String> props) {
                            String servicePackage = cfg.getServicePackage();
                            if (servicePackage != null) {
                                props.put("servicePackage", servicePackage);
                            }
                            Enumeration<?> names = cfg.getProps().propertyNames();
                            while (names.hasMoreElements()) {
                                String key = (String)names.nextElement();
                                props.put(key, cfg.getProps().getProperty(key));
                            }
                        }

                        @Override
                        protected String getSpringResource() {
                            return cfg.getSpringFile();
                        }
                    };
                    springTest.start();
                }
                catch (IllegalStateException | BeansException e) {
                    logger.error("Starting Spring context failed", e);
                }
                next.evaluate();
            }
        };
    }

    protected Object createTest() throws Exception {
        return springTest.getContext().getBeanFactory().createBean(this.getTestClass().getJavaClass());
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RunnerConfiguration {
        public Class<? extends RunnerConfig> config() default RunnerConfig.class;

        public String svc();
    }

    public static class RunnerConfig {
        private final Properties props = new Properties();

        protected void addProperty(String key, String value) {
            this.props.setProperty(key.trim(), value);
        }

        public Properties getProps() {
            return this.props;
        }

        public String getSpringFile() {
            return "spring-test/beans.xml";
        }

        public String getServicePackage() {
            return null;
        }

        protected static Integer randomPort() {
            return (int)(Math.random() * 20000.0 + 10000.0);
        }
    }
}

