/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.springcxfdaemon;

import com.google.common.collect.Maps;
import de.taimos.daemon.DaemonLifecycleAdapter;
import de.taimos.daemon.DaemonStarter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public abstract class SpringDaemonAdapter
extends DaemonLifecycleAdapter {
    private static AbstractXmlApplicationContext context;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public boolean doStart() {
        try {
            this.doBeforeSpringStart();
        }
        catch (Exception e) {
            this.logger.error("Before spring failed", (Throwable)e);
            return false;
        }
        try {
            context = this.createSpringContext();
            String[] profiles = System.getProperty("profiles", "prod").split(",");
            context.getEnvironment().setActiveProfiles(profiles);
            PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
            configurer.setProperties(DaemonStarter.getDaemonProperties());
            context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
            context.setConfigLocation(this.getSpringResource());
            context.refresh();
        }
        catch (Exception e) {
            this.logger.error("Spring context failed", (Throwable)e);
            return false;
        }
        try {
            this.doAfterSpringStart();
        }
        catch (Exception e) {
            this.logger.error("After spring failed", (Throwable)e);
            return false;
        }
        return super.doStart();
    }

    protected void doAfterSpringStart() {
    }

    protected void doBeforeSpringStart() {
    }

    protected void doAfterSpringStop() {
    }

    protected void doBeforeSpringStop() {
    }

    protected AbstractXmlApplicationContext createSpringContext() {
        return new ClassPathXmlApplicationContext();
    }

    protected String getSpringResource() {
        return "spring/beans.xml";
    }

    protected String getConfigFile() {
        return "core.properties";
    }

    public boolean doStop() {
        try {
            this.doBeforeSpringStop();
        }
        catch (Exception e) {
            this.logger.error("Before spring stop failed", (Throwable)e);
            return false;
        }
        try {
            context.stop();
        }
        catch (Exception e) {
            this.logger.error("spring stop failed", (Throwable)e);
            return false;
        }
        try {
            this.doAfterSpringStop();
        }
        catch (Exception e) {
            this.logger.error("After spring stop failed", (Throwable)e);
            return false;
        }
        return super.doStart();
    }

    public Map<String, String> loadProperties() {
        try {
            Map props = DaemonLifecycleAdapter.loadPropertiesFile((String)this.getConfigFile());
            if (System.getProperty("servicePackage") == null) {
                props.put("servicePackage", ((Object)((Object)this)).getClass().getPackage().getName());
            }
            return props;
        }
        catch (Exception e) {
            this.logger.error("Error loading properties", (Throwable)e);
            return Maps.newHashMap();
        }
    }

    public static ApplicationContext getContext() {
        return context;
    }
}

