/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.sma.energymeter;

import de.taimos.sma.energymeter.SMAData;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMAReader
extends Thread {
    private static final int RECEIVE_TIMEOUT = 5000;
    private static final Logger logger = LoggerFactory.getLogger(SMAReader.class);
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private final String group;
    private final int port;
    private final SMACallback cb;
    private final AtomicBoolean running = new AtomicBoolean(true);

    public SMAReader(SMACallback cb) {
        this("239.12.255.254", 9522, cb);
    }

    public SMAReader(String group, int port, SMACallback cb) {
        this.group = group;
        this.port = port;
        this.cb = cb;
    }

    public void shutdown() {
        this.running.set(false);
    }

    @Override
    public void run() {
        byte[] b = new byte[1024];
        DatagramPacket dgram = new DatagramPacket(b, b.length);
        try (MulticastSocket socket = new MulticastSocket(this.port);){
            logger.debug("Start socket on group {} and port {}", (Object)this.group, (Object)this.port);
            socket.joinGroup(InetAddress.getByName(this.group));
            logger.debug("Setting receive timeout to {} milliseconds", (Object)5000);
            socket.setSoTimeout(5000);
            while (this.running.get()) {
                try {
                    logger.debug("Waiting for next datagram");
                    socket.receive(dgram);
                    byte[] data = Arrays.copyOfRange(dgram.getData(), 0, dgram.getLength());
                    dgram.setLength(b.length);
                    logger.debug("Received SMA data from {}", (Object)dgram.getAddress().toString());
                    this.cb.dataReceived(this.parse(data));
                }
                catch (SocketTimeoutException e) {
                    logger.warn("Didn't receive data within {} milliseconds", (Object)5000);
                    this.cb.timeout();
                }
                catch (Exception e) {
                    this.cb.error(e);
                }
            }
        }
        catch (Exception e) {
            this.cb.error(e);
        }
    }

    private SMAData parse(byte[] data) {
        if (data.length != 600) {
            logger.warn("Invalid datagram length: {}", (Object)data.length);
            throw new RuntimeException("invalid length");
        }
        byte[] serial = Arrays.copyOfRange(data, 20, 24);
        SMAData sma = new SMAData(new BigInteger(serial).toString());
        byte[] body = Arrays.copyOfRange(data, 28, 588);
        int i = 0;
        while (i < body.length) {
            if (body[i] != 0 || body[i + 3] != 0) {
                String head = this.byteToHex(body[i]) + this.byteToHex(body[i + 1]) + this.byteToHex(body[i + 2]) + this.byteToHex(body[i + 3]);
                logger.warn("Invalid field header found: {}", (Object)head);
                throw new RuntimeException("parse error");
            }
            String address = this.byteToHex(body[i + 1]);
            byte len = body[i + 2];
            int dataStart = i + 4;
            int dataEnd = i + 4 + len;
            byte[] dataBytes = Arrays.copyOfRange(body, dataStart, dataEnd);
            sma.add(address + len, new BigInteger(dataBytes));
            i = dataEnd;
        }
        return sma;
    }

    private String byteToHex(byte bytes) {
        char[] hexChars = new char[2];
        int v = bytes & 0xFF;
        hexChars[0] = hexArray[v >>> 4];
        hexChars[1] = hexArray[v & 0xF];
        return new String(hexChars);
    }

    public static interface SMACallback {
        public void dataReceived(SMAData var1);

        public void error(Exception var1);

        public void timeout();
    }
}

