/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.sma.energymeter;

import de.taimos.sma.energymeter.SMAField;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public final class SMAData {
    private final String serial;
    private final Map<String, BigInteger> map = new HashMap<String, BigInteger>();

    SMAData(String serial) {
        this.serial = serial;
    }

    void add(String key, BigInteger value) {
        this.map.put(key, value);
    }

    public BigDecimal getValue(SMAField field) {
        if (this.map.containsKey(field.getAddress())) {
            return new BigDecimal(this.map.get(field.getAddress())).divide(new BigDecimal(field.getDivisor()), field.getScale(), RoundingMode.HALF_UP);
        }
        return null;
    }

    public String getValueString(SMAField field) {
        BigDecimal value = this.getValue(field);
        if (value != null) {
            return value.toPlainString() + " " + field.getUnit();
        }
        return null;
    }

    public String getSerial() {
        return this.serial;
    }

    public String toString() {
        return this.map.toString();
    }
}

