/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.restutils;

import java.util.Collection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class RESTAssert {
    private static final Response.Status DEFAULT_STATUS_CODE = Response.Status.PRECONDITION_FAILED;

    public static void assertTrue(boolean condition) {
        RESTAssert.assertTrue(condition, DEFAULT_STATUS_CODE);
    }

    public static void assertTrue(boolean condition, Response.Status status) {
        RESTAssert.assertFalse(!condition, status);
    }

    public static void assertFalse(boolean condition) {
        RESTAssert.assertFalse(condition, DEFAULT_STATUS_CODE);
    }

    public static void assertFalse(boolean condition, Response.Status status) {
        if (condition) {
            throw new WebApplicationException(status);
        }
    }

    public static void assertNotNull(Object object) {
        RESTAssert.assertNotNull(object, DEFAULT_STATUS_CODE);
    }

    public static void assertNotNull(Object object, Response.Status status) {
        RESTAssert.assertTrue(object != null, status);
    }

    public static void assertNotEmpty(String string) {
        RESTAssert.assertNotEmpty(string, DEFAULT_STATUS_CODE);
    }

    public static void assertNotEmpty(String string, Response.Status status) {
        RESTAssert.assertNotNull(string, status);
        RESTAssert.assertFalse(string.isEmpty(), status);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        RESTAssert.assertNotEmpty(collection, DEFAULT_STATUS_CODE);
    }

    public static void assertNotEmpty(Collection<?> collection, Response.Status status) {
        RESTAssert.assertNotNull(collection, status);
        RESTAssert.assertFalse(collection.isEmpty(), status);
    }

    public static void assertSingleElement(Collection<?> collection) {
        RESTAssert.assertSingleElement(collection, DEFAULT_STATUS_CODE);
    }

    public static void assertSingleElement(Collection<?> collection, Response.Status status) {
        RESTAssert.assertNotNull(collection, status);
        RESTAssert.assertTrue(collection.size() == 1, status);
    }

    public static void assertEquals(Object one, Object two) {
        RESTAssert.assertEquals(one, two, DEFAULT_STATUS_CODE);
    }

    public static void assertEquals(Object one, Object two, Response.Status status) {
        if (one == null && two == null) {
            return;
        }
        RESTAssert.assertNotNull(one, status);
        RESTAssert.assertTrue(one.equals(two), status);
    }
}

