/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin.model;

import de.taimos.maven_redmine_plugin.model.DateDeserializer;
import de.taimos.maven_redmine_plugin.model.Ticket;
import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

public class TicketDeserializer
extends JsonDeserializer<Ticket> {
    public Ticket deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
        JsonNode json = jp.readValueAsTree();
        Ticket t = new Ticket();
        t.setId(json.get("id").getIntValue());
        t.setSubject(json.get("subject").getTextValue());
        t.setTracker(TicketDeserializer.getNestedName(json, "tracker"));
        t.setAssignee(TicketDeserializer.getNestedName(json, "assigned_to"));
        t.setAuthor(TicketDeserializer.getNestedName(json, "author"));
        if (json.has("created_on")) {
            t.setCreated(DateDeserializer.parse(json.get("created_on").getTextValue()));
        }
        if (json.has("start_date")) {
            t.setStartDate(DateDeserializer.parse(json.get("start_date").getTextValue()));
        }
        if (json.has("updated_on")) {
            t.setUpdated(DateDeserializer.parse(json.get("updated_on").getTextValue()));
        }
        if (json.has("description")) {
            t.setDescription(json.get("description").getTextValue());
        }
        t.setFixedVersion(TicketDeserializer.getNestedName(json, "fixed_version"));
        t.setPriority(TicketDeserializer.getNestedName(json, "priority"));
        t.setStatus(TicketDeserializer.getNestedName(json, "status"));
        return t;
    }

    private static String getNestedName(JsonNode json, String field) {
        if (json.has(field) && json.get(field).has("name")) {
            return json.get(field).get("name").getTextValue();
        }
        return null;
    }
}

