/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin.model;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

public class DateDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
        String text = jp.getText();
        return DateDeserializer.parse(text);
    }

    static Date parse(String text) throws JsonParseException {
        Date parsed = DateDeserializer.parseString(text, "yyyy-MM-dd'T'HH:mm:ssZ");
        if (parsed == null) {
            parsed = DateDeserializer.parseString(text, "yyyy-MM-dd");
        }
        if (parsed == null) {
            throw new RuntimeException("Cannot parse date");
        }
        return parsed;
    }

    private static Date parseString(String s, String pattern) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            return sdf.parse(s);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

