/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin;

import de.taimos.maven_redmine_plugin.AbstractChangelogMojo;
import de.taimos.maven_redmine_plugin.model.Version;
import java.io.File;
import java.io.FileWriter;
import org.apache.maven.plugin.MojoExecutionException;

public class RPMChangelogMojo
extends AbstractChangelogMojo {
    private File rpmChangelogFile;
    private String rpmChangelogAuthor;
    private String rpmMinimalVersion;

    @Override
    protected String getVersionHeader(String version, String date) {
        return String.format("* %s %s %s \n", date, this.rpmChangelogAuthor, version + "-1");
    }

    @Override
    protected void doChangelog(String changelog) throws MojoExecutionException {
        try (FileWriter fw = new FileWriter(this.rpmChangelogFile);){
            fw.write(changelog);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    @Override
    protected void prepareExecute() throws MojoExecutionException {
        try {
            this.rpmChangelogFile.getParentFile().mkdirs();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    @Override
    protected String getDateFormat() {
        return "EEE MMM dd yyyy";
    }

    @Override
    protected boolean includeVersion(Version v) {
        System.out.println("Check version" + v);
        boolean include = v.getProjectPrefix().equals(this.getProjectVersionPrefix()) && v.getStatus().equals("closed");
        System.out.println("Version check: " + include);
        if (include) {
            System.out.println("Compare: " + v.compareToVersion(this.rpmMinimalVersion));
            return v.compareToVersion(this.rpmMinimalVersion) >= 0;
        }
        return false;
    }
}

