/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin;

import de.taimos.maven_redmine_plugin.RedmineMojo;
import de.taimos.maven_redmine_plugin.model.Version;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class CloseVersionMojo
extends RedmineMojo {
    private String closeVersion;

    @Override
    protected void doExecute() throws MojoExecutionException {
        List<Version> versions = this.redmine.getVersions(this.getProjectIdentifier());
        for (Version v : versions) {
            if (!this.checkVersion(v)) continue;
            this.redmine.closeVersion(v);
            return;
        }
        if (this.getProjectVersionPrefix().isEmpty()) {
            throw new MojoExecutionException(String.format("No version %s found for project %s.", Version.cleanSnapshot(this.closeVersion), this.getProjectIdentifier()));
        }
        throw new MojoExecutionException(String.format("No version %s-%s found for project %s.", this.getProjectVersionPrefix(), Version.cleanSnapshot(this.closeVersion), this.getProjectIdentifier()));
    }

    private boolean checkVersion(Version v) {
        return v.getName().equals(Version.createName(this.getProjectVersionPrefix(), Version.cleanSnapshot(this.closeVersion)));
    }
}

