/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin;

import de.taimos.maven_redmine_plugin.AbstractChangelogMojo;
import de.taimos.maven_redmine_plugin.model.Version;
import java.io.File;
import java.io.FileWriter;
import org.apache.maven.plugin.MojoExecutionException;

public class ChangelogMojo
extends AbstractChangelogMojo {
    private File changelogFile;
    private String changelogVersion;

    @Override
    protected String getVersionHeader(String version, String date) {
        return String.format("Version %s (%s) \n", version, date);
    }

    @Override
    protected boolean includeVersion(Version v) throws MojoExecutionException {
        String version = Version.cleanSnapshot(this.changelogVersion);
        return v.getName().equals(Version.createName(this.getProjectVersionPrefix(), version));
    }

    @Override
    protected void doChangelog(String changelog) throws MojoExecutionException {
        try (FileWriter fw = new FileWriter(this.changelogFile);){
            fw.write(changelog);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    @Override
    protected void prepareExecute() throws MojoExecutionException {
        try {
            this.changelogFile.getParentFile().mkdirs();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    @Override
    protected String getDateFormat() {
        return "MMM dd yyyy";
    }
}

