/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin.model;

import de.taimos.maven_redmine_plugin.model.DateDeserializer;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

public class Version
implements Comparable<Version> {
    @JsonDeserialize(using=DateDeserializer.class)
    private Date created_on;
    private String description;
    private Integer id;
    private String name;
    private String status;
    @JsonDeserialize(using=DateDeserializer.class)
    private Date updated_on;
    @JsonDeserialize(using=DateDeserializer.class)
    private Date due_date;

    public Date getCreated_on() {
        return this.created_on;
    }

    public void setCreated_on(Date created_on) {
        this.created_on = created_on;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getUpdated_on() {
        return this.updated_on;
    }

    public void setUpdated_on(Date updated_on) {
        this.updated_on = updated_on;
    }

    public Date getDue_date() {
        return this.due_date;
    }

    public void setDue_date(Date due_date) {
        this.due_date = due_date;
    }

    @JsonIgnore
    public String getProjectPrefix() {
        int pos = this.name.indexOf("-");
        if (pos == -1) {
            return "";
        }
        return this.name.substring(0, pos);
    }

    @JsonIgnore
    public int[] getNumericParts() {
        int pos = this.name.indexOf("-");
        if (pos == -1) {
            return Version.splitVersion(this.name);
        }
        return Version.splitVersion(this.name.substring(pos + 1));
    }

    public String toVersionString() {
        int pos = this.name.indexOf("-");
        if (pos == -1) {
            return this.name;
        }
        return this.name.substring(pos + 1);
    }

    @Override
    public int compareTo(Version o) {
        int comp = this.getProjectPrefix().compareTo(o.getProjectPrefix());
        if (comp == 0) {
            comp = Version.compareVersions(this.getNumericParts(), o.getNumericParts());
        }
        return comp;
    }

    private static int compareVersions(String me, String other) {
        return Version.compareVersions(Version.splitVersion(me), Version.splitVersion(other));
    }

    private static int compareVersions(int[] me, int[] other) {
        if (me[0] == other[0]) {
            if (me[1] == other[1]) {
                return me[2] - other[2];
            }
            return me[1] - other[1];
        }
        return me[0] - other[0];
    }

    private static int[] splitVersion(String version) {
        String[] split = version.split("\\.");
        if (split.length > 3) {
            throw new RuntimeException("Illegal version name");
        }
        int[] res = new int[3];
        switch (split.length) {
            case 3: {
                res[2] = Integer.valueOf(split[2]);
            }
            case 2: {
                res[1] = Integer.valueOf(split[1]);
            }
            case 1: {
                res[0] = Integer.valueOf(split[0]);
                break;
            }
        }
        return res;
    }

    public static String createName(String projectPrefix, String version) {
        if (projectPrefix != null && !projectPrefix.isEmpty()) {
            return projectPrefix + "-" + version;
        }
        return version;
    }

    public static String cleanSnapshot(String version) {
        return version.replaceAll("-SNAPSHOT", "");
    }

    public static void main(String[] args) {
        System.out.println(Version.compareVersions("1.0.0", "1.1.0"));
        System.out.println(Version.compareVersions("2.0.0", "1.1.0"));
        System.out.println(Version.compareVersions("2", "1.1.0"));
        System.out.println(Version.compareVersions("1.2.0", "1.1.0"));
        System.out.println(Version.compareVersions("1.0.1", "1.1.0"));
        System.out.println(Version.compareVersions("1.1.1", "1.1"));
    }
}

