/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin;

import de.taimos.maven_redmine_plugin.RedmineMojo;
import de.taimos.maven_redmine_plugin.model.Ticket;
import de.taimos.maven_redmine_plugin.model.Version;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractChangelogMojo
extends RedmineMojo {
    @Override
    protected void doExecute() throws MojoExecutionException {
        this.prepareExecute();
        List<Version> versions = this.redmine.getVersions(this.getProjectIdentifier());
        SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormat());
        Collections.sort(versions);
        Collections.reverse(versions);
        StringBuilder changelogText = new StringBuilder();
        for (Version v : versions) {
            if (!this.includeVersion(v)) continue;
            String date = sdf.format(v.getUpdated_on());
            changelogText.append(this.getVersionHeader(v.toVersionString(), date));
            List<Ticket> tickets = this.redmine.getClosedTickets(this.getProjectIdentifier(), v.getId());
            if (tickets.isEmpty()) {
                this.getLog().warn((CharSequence)("No tickets found for version: " + v.toVersionString()));
                continue;
            }
            Collections.sort(tickets);
            for (Ticket ticket : tickets) {
                changelogText.append("- ");
                changelogText.append(ticket.toString());
                changelogText.append('\n');
            }
            changelogText.append("\n");
        }
        this.doChangelog(changelogText.toString());
    }

    protected abstract void doChangelog(String var1) throws MojoExecutionException;

    protected abstract String getVersionHeader(String var1, String var2);

    protected abstract boolean includeVersion(Version var1) throws MojoExecutionException;

    protected String getDateFormat() {
        return "MMM dd yyyy";
    }

    protected void prepareExecute() throws MojoExecutionException {
    }
}

