/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin.model;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

public class DateDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
        String text = jp.getText();
        return DateDeserializer.parse(text);
    }

    static Date parse(String text) throws JsonParseException {
        SimpleDateFormat oldDF;
        SimpleDateFormat newDF;
        Date parsed = null;
        try {
            newDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            parsed = newDF.parse(text);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (parsed == null) {
            try {
                newDF = new SimpleDateFormat("yyyy-MM-dd");
                parsed = newDF.parse(text);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (parsed == null) {
            try {
                oldDF = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss Z");
                parsed = oldDF.parse(text);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (parsed == null) {
            try {
                oldDF = new SimpleDateFormat("yyyy/MM/dd");
                parsed = oldDF.parse(text);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (parsed == null) {
            throw new RuntimeException("Cannot parse date");
        }
        return parsed;
    }
}

