/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin;

import de.taimos.maven_redmine_plugin.RedmineMojo;
import de.taimos.maven_redmine_plugin.model.Ticket;
import de.taimos.maven_redmine_plugin.model.Version;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class RPMChangelogMojo
extends RedmineMojo {
    private File rpmChangelogFile;
    private String rpmChangelogAuthor;

    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            this.rpmChangelogFile.getParentFile().mkdirs();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        List<Version> versions = this.redmine.getVersions(this.getProjectIdentifier());
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd yyyy");
        Collections.sort(versions);
        Collections.reverse(versions);
        StringBuilder changelogText = new StringBuilder();
        for (Version v : versions) {
            if (!this.includeVersion(v)) continue;
            String date = sdf.format(v.getUpdated_on());
            String versionString = v.toVersionString() + "-1";
            changelogText.append(String.format("* %s %s %s \n", date, this.rpmChangelogAuthor, versionString));
            List<Ticket> tickets = this.redmine.getClosedTickets(this.getProjectIdentifier(), v.getId());
            Collections.sort(tickets);
            for (Ticket ticket : tickets) {
                changelogText.append("- ");
                changelogText.append(ticket.toString());
                changelogText.append('\n');
            }
            changelogText.append("\n");
        }
        try (FileWriter fw = new FileWriter(this.rpmChangelogFile);){
            fw.write(changelogText.toString());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean includeVersion(Version v) {
        return v.getProjectPrefix().equals(this.getProjectVersionPrefix()) && v.getStatus().equals("closed");
    }
}

