/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin;

import de.taimos.maven_redmine_plugin.RedmineMojo;
import de.taimos.maven_redmine_plugin.model.Ticket;
import de.taimos.maven_redmine_plugin.model.Version;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class ChangelogMojo
extends RedmineMojo {
    private File changelogFile;
    private String changelogVersion;

    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            this.changelogFile.getParentFile().mkdirs();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        List<Version> versions = this.redmine.getVersions(this.getProjectIdentifier());
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yyyy");
        Collections.sort(versions);
        Collections.reverse(versions);
        StringBuilder changelogText = new StringBuilder();
        for (Version v : versions) {
            if (!this.checkVersion(v)) continue;
            String date = sdf.format(v.getUpdated_on());
            changelogText.append(String.format("Version %s (%s) \n", v.toVersionString(), date));
            List<Ticket> tickets = this.redmine.getClosedTickets(this.getProjectIdentifier(), v.getId());
            Collections.sort(tickets);
            for (Ticket ticket : tickets) {
                changelogText.append("- ");
                changelogText.append(ticket.toString());
                changelogText.append('\n');
            }
            changelogText.append("\n");
        }
        if (changelogText.length() == 0) {
            this.getLog().warn((CharSequence)("No tickets found for version: " + this.changelogVersion));
        }
        try (FileWriter fw = new FileWriter(this.changelogFile);){
            fw.write(changelogText.toString());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean checkVersion(Version v) {
        String version = Version.cleanSnapshot(this.changelogVersion);
        return v.getName().equals(Version.createName(this.getProjectVersionPrefix(), version));
    }
}

