/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.ldjson.cxf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LDJSONStreamOutput
implements StreamingOutput {
    private static final String LINE_DELIMITER = "\r\n";
    private static final String ENCODING = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(LDJSONStreamOutput.class);
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final LinkedBlockingQueue<String> messageQ = new LinkedBlockingQueue();
    private final boolean heartbeat;
    private final int heartbeatMillis;

    public LDJSONStreamOutput() {
        this(false);
    }

    public LDJSONStreamOutput(boolean heartbeat) {
        this.heartbeat = heartbeat;
        this.heartbeatMillis = 5000;
    }

    public LDJSONStreamOutput(int heartbeatMillis) {
        this.heartbeat = true;
        this.heartbeatMillis = heartbeatMillis;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void setRunning(boolean running) {
        this.running.set(running);
    }

    public void write(OutputStream output) throws IOException, WebApplicationException {
        this.startStream();
        if (this.heartbeat) {
            this.startHeartbeat();
        }
        while (this.isRunning()) {
            try {
                String poll = this.messageQ.take();
                if (poll == null || !this.isRunning()) continue;
                try {
                    output.write(poll.getBytes(ENCODING));
                    output.write(LINE_DELIMITER.getBytes(ENCODING));
                    output.flush();
                }
                catch (Exception e) {
                    this.running.set(false);
                }
            }
            catch (InterruptedException ie) {
                logger.info("stream endpoint was interrupted");
            }
            catch (Exception e) {
                logger.error("Error on stream endpoint", (Throwable)e);
            }
        }
        try {
            output.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopStream();
    }

    private void startHeartbeat() {
        Thread heartbeatThread = new Thread(){

            @Override
            public void run() {
                String heartbeatMessage = LDJSONStreamOutput.this.getHeartbeatMessage();
                while (LDJSONStreamOutput.this.running.get()) {
                    try {
                        LDJSONStreamOutput.this.messageQ.add(heartbeatMessage);
                    }
                    catch (Exception e) {
                        logger.error("Error on stream heartbeat", (Throwable)e);
                    }
                    try {
                        Thread.sleep(LDJSONStreamOutput.this.heartbeatMillis);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        heartbeatThread.setDaemon(true);
        heartbeatThread.start();
    }

    public void writeObject(String json) {
        this.messageQ.add(json);
    }

    public void writeObject(Object obj) throws JsonProcessingException {
        this.writeObject(this.getMapper().writeValueAsString(obj));
    }

    protected void stopStream() {
    }

    protected void startStream() {
    }

    protected ObjectMapper getMapper() {
        return new ObjectMapper();
    }

    protected String getHeartbeatMessage() {
        return "{}";
    }
}

