/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.maven.model;

import de.taimos.dvalin.interconnect.model.maven.GenerationContext;
import de.taimos.dvalin.interconnect.model.maven.exceptions.IVOGenerationError;
import de.taimos.dvalin.interconnect.model.maven.imports.Imports;
import de.taimos.dvalin.interconnect.model.metamodel.IGeneratorDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public abstract class GeneratorModel<T extends IGeneratorDefinition, K extends Imports<T>> {
    public static final String DEFAULT_TARGET_DIR = "/generated-sources/model/";
    protected K imports;
    protected T definition;
    private Log logger;
    protected List<Object> modifiableChildren = new ArrayList<Object>();

    public abstract Collection<GenerationContext> getGenerationContexts();

    protected abstract void handleChild(Object var1);

    public String getTargetFolder() {
        return DEFAULT_TARGET_DIR + this.definition.getPackageName().replace('.', File.separatorChar);
    }

    public void init(T ivoDefinition, K imports, Log logger) {
        if (ivoDefinition == null || imports == null) {
            throw new IVOGenerationError("Failed. Generator was not correctly initialized");
        }
        this.logger = logger;
        this.definition = ivoDefinition;
        this.imports = imports;
        ((Imports)this.imports).initDefaults();
        if (this.definition.getChildren() != null) {
            this.modifiableChildren.addAll(this.definition.getChildren());
        }
        this.beforeChildHandling();
        for (Object child : new ArrayList<Object>(this.modifiableChildren)) {
            this.handleChild(child);
        }
    }

    protected void beforeChildHandling() {
    }

    protected void addChild(Object child) {
        if (child != null) {
            this.modifiableChildren.add(child);
        }
    }

    protected void addChildren(Collection<Object> children) {
        if (children != null) {
            this.modifiableChildren.addAll(children);
        }
    }

    public Log getLogger() {
        return this.logger;
    }
}

