/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.maven;

import de.taimos.dvalin.interconnect.model.maven.GenerationContext;
import de.taimos.dvalin.interconnect.model.maven.model.GeneratorModel;
import de.taimos.dvalin.interconnect.model.maven.model.ModelTools;
import de.taimos.dvalin.interconnect.model.metamodel.IGeneratorDefinition;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.event.implement.IncludeRelativePath;
import org.apache.velocity.context.Context;

public class GeneratorHelper {
    public static void writeFile(GeneratorModel<?, ?> model, String targetDir) throws MojoExecutionException {
        if (model.getGenerationContexts() == null || model.getGenerationContexts().isEmpty()) {
            return;
        }
        for (GenerationContext generationContext : model.getGenerationContexts()) {
            generationContext.setTemplate(GeneratorHelper.prepareTemplate(model.getLogger(), generationContext));
            generationContext.setTargetDir(targetDir + model.getTargetFolder());
            GeneratorHelper.createFileWithTemplate(model, generationContext);
        }
    }

    private static void createFileWithTemplate(GeneratorModel<?, ?> model, GenerationContext generationContext) throws MojoExecutionException {
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(generationContext.getTargetPath()), StandardCharsets.UTF_8);){
            model.getLogger().info((CharSequence)("Creating file " + generationContext.getTargetPath()));
            VelocityContext context = new VelocityContext();
            context.put("model", model);
            context.put("tool", (Object)new ModelTools());
            context.put("clazzName", (Object)generationContext.getTargetFileName());
            generationContext.getTemplate().merge((Context)context, (Writer)fw);
        }
        catch (IOException e) {
            model.getLogger().error((CharSequence)("Failed to write the generated file " + generationContext.getTargetFileName()), (Throwable)e);
            throw new MojoExecutionException("Failed to write the generated file " + generationContext.getTargetFileName(), (Exception)e);
        }
    }

    private static Template prepareTemplate(Log log, GenerationContext generationContext) throws MojoExecutionException {
        Template template;
        try {
            template = Velocity.getTemplate((String)generationContext.getTemplatePath(), (String)generationContext.getTemplateEncoding());
        }
        catch (Exception e) {
            log.error((CharSequence)("Failed to retrieve Template " + generationContext.getTemplatePath()), (Throwable)e);
            throw new MojoExecutionException("Failed to retrieve Template " + generationContext.getTemplatePath(), e);
        }
        return template;
    }

    public static Properties getVelocityDefaultProps() {
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.setProperty("event_handler.include.class", IncludeRelativePath.class.getName());
        return props;
    }

    public static <T extends IGeneratorDefinition> T parseXML(Class<T> clazz, File f) throws MojoExecutionException {
        try {
            JAXBContext jcontext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jcontext.createUnmarshaller();
            unmarshaller.setEventHandler(validationEvent -> false);
            return (T)((IGeneratorDefinition)unmarshaller.unmarshal(f));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to read input file " + f.getAbsolutePath(), e);
        }
    }
}

