/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.maven;

import de.taimos.dvalin.interconnect.model.maven.GeneratorHelper;
import de.taimos.dvalin.interconnect.model.maven.ModelType;
import de.taimos.dvalin.interconnect.model.maven.model.IAdditionalMemberHandler;
import de.taimos.dvalin.interconnect.model.maven.model.event.EventModel;
import de.taimos.dvalin.interconnect.model.maven.model.event.InterfaceEventModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.IVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.InterfaceIVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.filter.FindByIdAuditedIVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.filter.FindByIdIVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.filter.FindIVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.filter.FindInterfaceModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.modify.CreateIVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.modify.DeleteIVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.modify.SaveIVOModel;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.modify.UpdateIVOModel;
import de.taimos.dvalin.interconnect.model.maven.validation.DefinitionValidator;
import de.taimos.dvalin.interconnect.model.maven.validation.SimpleInvalidFieldNameValidator;
import de.taimos.dvalin.interconnect.model.metamodel.IGeneratorDefinition;
import de.taimos.dvalin.interconnect.model.metamodel.defs.EventDef;
import de.taimos.dvalin.interconnect.model.metamodel.defs.IVODef;
import java.io.File;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.app.Velocity;

@Mojo(name="generateModel", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateModel
extends AbstractMojo {
    @Parameter(required=true, property="project.build.directory")
    private String outputDirectory;
    @Parameter
    private File[] ivoPaths;
    @Parameter
    private File[] eventPaths;
    @Parameter(required=true, property="project", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Objects.hashCode(null);
        Velocity.init((Properties)GeneratorHelper.getVelocityDefaultProps());
        this.preExecute();
        this.execute(this.ivoPaths, ModelType.IVO);
        this.execute(this.eventPaths, ModelType.EVENT);
    }

    protected void preExecute() {
        DefinitionValidator.addFieldValidator(new SimpleInvalidFieldNameValidator("handler"));
    }

    protected void processFileAsIVO(File f) throws MojoExecutionException {
        IVODef ivoDef = GeneratorHelper.parseXML(IVODef.class, f);
        DefinitionValidator.validate((IGeneratorDefinition)ivoDef);
        GeneratorHelper.writeFile(new InterfaceIVOModel(ivoDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
        GeneratorHelper.writeFile(new IVOModel(ivoDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
        GeneratorHelper.writeFile(new FindIVOModel(ivoDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
        GeneratorHelper.writeFile(new FindInterfaceModel(ivoDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
        GeneratorHelper.writeFile(new FindByIdIVOModel(ivoDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
        GeneratorHelper.writeFile(new FindByIdAuditedIVOModel(ivoDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
        GeneratorHelper.writeFile(new SaveIVOModel(ivoDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
        GeneratorHelper.writeFile(new CreateIVOModel(ivoDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
        GeneratorHelper.writeFile(new UpdateIVOModel(ivoDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
        GeneratorHelper.writeFile(new DeleteIVOModel(ivoDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected void processFileAsEvent(File f) throws MojoExecutionException {
        EventDef eventDef = GeneratorHelper.parseXML(EventDef.class, f);
        DefinitionValidator.validate((IGeneratorDefinition)eventDef);
        GeneratorHelper.writeFile(new InterfaceEventModel(eventDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
        GeneratorHelper.writeFile(new EventModel(eventDef, this.getLog(), new IAdditionalMemberHandler[0]), this.getOutputDirectory());
    }

    private void execute(File[] dir, ModelType type) throws MojoExecutionException {
        try {
            if (dir != null && dir.length > 0) {
                for (File f : dir) {
                    this.processDirectory(f, type);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed...", e);
        }
    }

    private void processDirectory(File f, ModelType type) throws MojoExecutionException {
        File[] defFiles;
        this.getLog().info((CharSequence)("Processing Directory: " + f.getAbsolutePath()));
        File[] dirs = f.listFiles(File::isDirectory);
        if (dirs != null) {
            for (File file : dirs) {
                this.processDirectory(file, type);
            }
        }
        if ((defFiles = f.listFiles((dir, name) -> name.endsWith(".xml"))) != null) {
            block5: for (File defFile : defFiles) {
                switch (type) {
                    case IVO: {
                        this.handleIVOGeneration(f, defFile);
                        continue block5;
                    }
                    case EVENT: {
                        this.handleEventGeneration(f, defFile);
                        continue block5;
                    }
                }
            }
        }
    }

    private void handleEventGeneration(File f, File defFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Generating files for Event in " + defFile.getAbsolutePath()));
        try {
            this.processFileAsEvent(defFile);
            File path = new File(this.getOutputDirectory() + "/generated-sources/model/");
            this.project.addCompileSourceRoot(path.getAbsolutePath());
        }
        catch (MojoExecutionException e) {
            if (e.getCause().getMessage().contains("ivo")) {
                this.getLog().warn((CharSequence)"An ivo file was found in the ivo directory. Please fix this.");
                this.processFileAsIVO(defFile);
            }
            this.getLog().error((CharSequence)("Failed to read input file " + f.getAbsolutePath()), (Throwable)e);
            throw e;
        }
    }

    private void handleIVOGeneration(File f, File defFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Generating files for IVO in " + defFile.getAbsolutePath()));
        try {
            this.processFileAsIVO(defFile);
            File path = new File(this.getOutputDirectory() + "/generated-sources/model/");
            this.project.addCompileSourceRoot(path.getAbsolutePath());
        }
        catch (MojoExecutionException e) {
            if (e.getCause().getMessage().contains("event")) {
                this.getLog().warn((CharSequence)"An event file was found in the ivo directory. Please fix this.");
                this.processFileAsEvent(defFile);
            }
            this.getLog().error((CharSequence)("Failed to read input file " + f.getAbsolutePath()), (Throwable)e);
            throw e;
        }
    }
}

