/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.maven.model.ivo;

import de.taimos.dvalin.interconnect.model.ivo.IIdentity;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.ivo.util.IIVOAuditing;
import de.taimos.dvalin.interconnect.model.maven.imports.ivo.IVOInterfaceImports;
import de.taimos.dvalin.interconnect.model.maven.model.ivo.AbstractIVOModel;
import de.taimos.dvalin.interconnect.model.metamodel.defs.IVODef;
import de.taimos.dvalin.interconnect.model.metamodel.memberdef.ImplementsDef;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class InterfaceIVOModel
extends AbstractIVOModel {
    private static final String IVO_INTERFACE = "ivo/ivoInterface.vm";

    public InterfaceIVOModel(IVODef definition, Log logger) {
        this.init(definition, new IVOInterfaceImports(), logger);
    }

    @Override
    protected boolean interfaceMode() {
        return true;
    }

    @Override
    public Map<String, String> generateClazzWithTemplates() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.getInterfaceClazzName(), IVO_INTERFACE);
        return result;
    }

    @Override
    protected void beforeChildHandling() {
        super.beforeChildHandling();
        ((IVODef)this.definition).getChildren().add(this.getDefaultImplements());
        if (this.isAudited()) {
            ((IVODef)this.definition).getChildren().add(this.getImplementsDef(IIVOAuditing.class));
        }
        if (this.isIdentity() && !this.hasParentClazz()) {
            ((IVODef)this.definition).getChildren().add(this.getImplementsDef(IIdentity.class));
        }
    }

    private ImplementsDef getDefaultImplements() {
        if (this.hasParentClazz()) {
            ImplementsDef def = new ImplementsDef();
            def.setName(this.getParentInterfaceName());
            def.setPkgName(((IVODef)this.definition).getParentPkgName());
            return def;
        }
        return this.getImplementsDef(IVO.class);
    }
}

